/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

public class GrantSkillXp
extends LootFunction {
    private final Skills skill;
    private final float xp;

    protected GrantSkillXp(ILootCondition[] lootConditions, Skills skill, float xp) {
        super(lootConditions);
        this.skill = skill;
        this.xp = xp;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
        if (!(entity instanceof PlayerEntity)) {
            entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        }
        if (entity instanceof ServerPlayerEntity) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)entity).stats().addXp(this.skill, this.xp, false, false);
        }
        return stack;
    }

    public static LootFunction.Builder<?> builder(Skills skill, float xp) {
        return GrantSkillXp.func_215860_a(conditions -> new GrantSkillXp((ILootCondition[])conditions, skill, xp));
    }

    public static class Serializer
    extends LootFunction.Serializer<GrantSkillXp> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "grant_skill_xp"), GrantSkillXp.class);
        }

        public void serialize(JsonObject object, GrantSkillXp function, JsonSerializationContext context) {
            super.func_186532_a(object, (LootFunction)function, context);
            object.addProperty("skill", function.skill.toString().toLowerCase());
            object.addProperty("xp", (Number)Float.valueOf(function.xp));
        }

        public GrantSkillXp deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            return new GrantSkillXp(conditions, Skills.valueOf(JSONUtils.func_151200_h((JsonObject)object, (String)"skill").toUpperCase()), JSONUtils.func_151217_k((JsonObject)object, (String)"xp"));
        }
    }
}

