/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.world.BlockEvent;
import net.tslat.aoa3.event.PlayerEvents;

public class HarvestDropsLootModifier
extends LootModifier {
    protected HarvestDropsLootModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!context.func_216033_a(LootParameters.field_216289_i) || !context.func_216033_a(LootParameters.field_216281_a)) {
            return generatedLoot;
        }
        Entity harvester = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(harvester instanceof PlayerEntity)) {
            return generatedLoot;
        }
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        NonNullList loot = NonNullList.func_191196_a();
        loot.addAll(generatedLoot);
        BlockEvent.HarvestDropsEvent ev = new BlockEvent.HarvestDropsEvent((World)context.func_202879_g(), (BlockPos)context.func_216031_c(LootParameters.field_216286_f), (BlockState)context.func_216031_c(LootParameters.field_216287_g), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool), 1.0f, loot, (PlayerEntity)harvester, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0);
        PlayerEvents.onBlockHarvest(ev);
        return ev.getDrops();
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<HarvestDropsLootModifier> {
        public HarvestDropsLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new HarvestDropsLootModifier(lootConditions == null ? new ILootCondition[]{} : lootConditions);
        }
    }
}

