/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public class RollExtraTablesLootModifier
extends LootModifier {
    private final ResourceLocation[] additionalTables;

    protected RollExtraTablesLootModifier(ILootCondition[] conditions, ResourceLocation[] additionalTables) {
        super(conditions);
        this.additionalTables = additionalTables;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (ResourceLocation tableLocation : this.additionalTables) {
            LootTable table = context.func_227502_a_(tableLocation);
            boolean compatible = true;
            for (LootParameter param : table.func_216122_a().func_216277_a()) {
                if (context.func_216033_a(param)) continue;
                compatible = false;
                Logging.logMessage(Level.WARN, "Incompatible loot table found for Roll Extra Tables Loot Modifier: " + tableLocation.toString() + ", missing: " + param.func_216247_a().toString());
                break;
            }
            if (!compatible || table == LootTable.field_186464_a) continue;
            table.func_216120_b(context, generatedLoot::add);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RollExtraTablesLootModifier> {
        public RollExtraTablesLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            JsonArray tables = JSONUtils.func_151214_t((JsonObject)object, (String)"tables");
            ResourceLocation[] tableList = new ResourceLocation[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                tableList[i] = new ResourceLocation(tables.get(i).getAsString());
            }
            return new RollExtraTablesLootModifier(lootConditions, tableList);
        }
    }
}

