/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.misc;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoATags;

public class AoAPortalFrame {
    private static final ArrayList<Vec3i> northSouthPattern = new ArrayList();
    private static final ArrayList<Vec3i> eastWestPattern = new ArrayList();

    public static PortalDirection testFrameForActivation(World world, BlockPos activationPos, Direction sideClicked, PortalBlock portalBlock) {
        switch (sideClicked) {
            case NORTH: 
            case SOUTH: {
                return AoAPortalFrame.testNorthSouthPortalFrame(world, activationPos, portalBlock);
            }
            case EAST: 
            case WEST: {
                return AoAPortalFrame.testEastWestPortalFrame(world, activationPos, portalBlock);
            }
        }
        PortalDirection dir = AoAPortalFrame.testNorthSouthPortalFrame(world, activationPos, portalBlock);
        if (dir == PortalDirection.INVALID) {
            dir = AoAPortalFrame.testEastWestPortalFrame(world, activationPos, portalBlock);
        }
        return dir;
    }

    public static PortalDirection testNorthSouthPortalFrame(World world, BlockPos basePos, PortalBlock portalBlock) {
        Block carvedRuneTravel = null;
        Block carvedRuneReality = null;
        Block carvedRuneSpace = null;
        Block carvedRuneDirection = null;
        int ancientRockCount = 0;
        for (Vec3i pos : northSouthPattern) {
            Block testBlock = world.func_180495_p(basePos.func_177971_a(pos)).func_177230_c();
            if (testBlock == AoABlocks.ANCIENT_ROCK.get()) {
                ++ancientRockCount;
                continue;
            }
            if (!testBlock.func_203417_a(AoATags.Blocks.CARVED_RUNE)) continue;
            if (testBlock == AoABlocks.CARVED_RUNE_OF_TRAVEL.get()) {
                if (carvedRuneTravel != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneTravel = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_REALITY.get()) {
                if (carvedRuneReality != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneReality = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_SPACE.get()) {
                if (carvedRuneSpace != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneSpace = testBlock;
                continue;
            }
            if (testBlock != AoABlocks.CARVED_RUNE_OF_DIRECTION.get()) continue;
            if (carvedRuneDirection != null) {
                return PortalDirection.INVALID;
            }
            carvedRuneDirection = testBlock;
        }
        if (ancientRockCount == 13 && carvedRuneDirection != null && carvedRuneReality != null && carvedRuneSpace != null && carvedRuneTravel != null) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < 5; ++y) {
                    BlockState state = world.func_180495_p(basePos.func_177982_a(x, y, 0));
                    if (state.func_177230_c() instanceof PortalBlock) {
                        if (state.func_177230_c() != portalBlock) continue;
                        return PortalDirection.EXISTING;
                    }
                    if (state.func_185904_a().func_76222_j()) continue;
                    return PortalDirection.INVALID;
                }
            }
            return PortalDirection.NORTH_SOUTH;
        }
        return PortalDirection.INVALID;
    }

    public static PortalDirection testEastWestPortalFrame(World world, BlockPos basePos, PortalBlock portalBlock) {
        Block carvedRuneTravel = null;
        Block carvedRuneReality = null;
        Block carvedRuneSpace = null;
        Block carvedRuneDirection = null;
        int ancientRockCount = 0;
        for (Vec3i pos : eastWestPattern) {
            Block testBlock = world.func_180495_p(basePos.func_177971_a(pos)).func_177230_c();
            if (testBlock == AoABlocks.ANCIENT_ROCK.get()) {
                ++ancientRockCount;
                continue;
            }
            if (!testBlock.func_203417_a(AoATags.Blocks.CARVED_RUNE)) continue;
            if (testBlock == AoABlocks.CARVED_RUNE_OF_TRAVEL.get()) {
                if (carvedRuneTravel != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneTravel = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_REALITY.get()) {
                if (carvedRuneReality != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneReality = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_SPACE.get()) {
                if (carvedRuneSpace != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneSpace = testBlock;
                continue;
            }
            if (testBlock != AoABlocks.CARVED_RUNE_OF_DIRECTION.get()) continue;
            if (carvedRuneDirection != null) {
                return PortalDirection.INVALID;
            }
            carvedRuneDirection = testBlock;
        }
        if (ancientRockCount == 13 && carvedRuneDirection != null && carvedRuneReality != null && carvedRuneSpace != null && carvedRuneTravel != null) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 1; y < 5; ++y) {
                    BlockState state = world.func_180495_p(basePos.func_177982_a(0, y, z));
                    if (state.func_177230_c() instanceof PortalBlock) {
                        if (state.func_177230_c() != portalBlock) continue;
                        return PortalDirection.EXISTING;
                    }
                    if (state.func_185904_a().func_76222_j()) continue;
                    return PortalDirection.INVALID;
                }
            }
            return PortalDirection.EAST_WEST;
        }
        return PortalDirection.INVALID;
    }

    public static void lightPortalFrame(World world, BlockPos basePos, PortalDirection direction, PortalBlock portalBlock) {
        switch (direction) {
            case NORTH_SOUTH: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = 1; y < 5; ++y) {
                        world.func_180501_a(basePos.func_177982_a(x, y, 0), (BlockState)portalBlock.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.Z), 2);
                    }
                }
                break;
            }
            case EAST_WEST: {
                for (int z = -1; z < 2; ++z) {
                    for (int y = 1; y < 5; ++y) {
                        world.func_180501_a(basePos.func_177982_a(0, y, z), portalBlock.func_176223_P(), 2);
                    }
                }
                break;
            }
        }
    }

    static {
        northSouthPattern.add(new Vec3i(-2, 0, 0));
        northSouthPattern.add(new Vec3i(-1, 0, 0));
        northSouthPattern.add(new Vec3i(0, 0, 0));
        northSouthPattern.add(new Vec3i(1, 0, 0));
        northSouthPattern.add(new Vec3i(2, 0, 0));
        northSouthPattern.add(new Vec3i(2, 1, 0));
        northSouthPattern.add(new Vec3i(2, 2, 0));
        northSouthPattern.add(new Vec3i(2, 3, 0));
        northSouthPattern.add(new Vec3i(2, 4, 0));
        northSouthPattern.add(new Vec3i(2, 5, 0));
        northSouthPattern.add(new Vec3i(1, 5, 0));
        northSouthPattern.add(new Vec3i(0, 5, 0));
        northSouthPattern.add(new Vec3i(-1, 5, 0));
        northSouthPattern.add(new Vec3i(-2, 5, 0));
        northSouthPattern.add(new Vec3i(-2, 4, 0));
        northSouthPattern.add(new Vec3i(-2, 3, 0));
        northSouthPattern.add(new Vec3i(-2, 2, 0));
        northSouthPattern.add(new Vec3i(-2, 1, 0));
        eastWestPattern.add(new Vec3i(0, 0, -2));
        eastWestPattern.add(new Vec3i(0, 0, -1));
        eastWestPattern.add(new Vec3i(0, 0, 0));
        eastWestPattern.add(new Vec3i(0, 0, 1));
        eastWestPattern.add(new Vec3i(0, 0, 2));
        eastWestPattern.add(new Vec3i(0, 1, 2));
        eastWestPattern.add(new Vec3i(0, 2, 2));
        eastWestPattern.add(new Vec3i(0, 3, 2));
        eastWestPattern.add(new Vec3i(0, 4, 2));
        eastWestPattern.add(new Vec3i(0, 5, 2));
        eastWestPattern.add(new Vec3i(0, 5, 1));
        eastWestPattern.add(new Vec3i(0, 5, 0));
        eastWestPattern.add(new Vec3i(0, 5, -1));
        eastWestPattern.add(new Vec3i(0, 5, -2));
        eastWestPattern.add(new Vec3i(0, 4, -2));
        eastWestPattern.add(new Vec3i(0, 3, -2));
        eastWestPattern.add(new Vec3i(0, 2, -2));
        eastWestPattern.add(new Vec3i(0, 1, -2));
    }

    public static enum PortalDirection {
        INVALID,
        EXISTING,
        NORTH_SOUTH,
        EAST_WEST;

    }
}

