/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.misc;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.worldgen.worlds.ancientcavern.AncientCavernTeleporter;
import net.tslat.aoa3.worldgen.worlds.immortallis.ImmortallisTeleporter;

public abstract class AoATeleporter
implements ITeleporter {
    public abstract HashMap<Long, BlockPos> getCachedPortalMap();

    public abstract PortalBlock getPortalBlock();

    public abstract Block getBorderBlock();

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> entityPlacementFunction) {
        block15: {
            BlockPos pos;
            PlayerDataManager plData;
            block16: {
                PortalCoordinatesContainer returnPortalLoc;
                plData = null;
                boolean failedPortalReturn = false;
                if (entity instanceof ServerPlayerEntity) {
                    entity.func_189654_d(false);
                    plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)entity);
                    PortalCoordinatesContainer loc = plData.getPortalReturnLocation(destWorld.func_201675_m().func_186058_p());
                    if (loc != null) {
                        BlockPos locPos = loc.asBlockPos();
                        Block locationBlock = destWorld.func_180495_p(locPos).func_177230_c();
                        if (locationBlock == this.getPortalBlock()) {
                            this.placeInPortal((World)destWorld, entity, locPos);
                            return this.customPlayerPlacementFunction((ServerPlayerEntity)entity, currentWorld, destWorld, false);
                        }
                        if (!(locationBlock instanceof PortalBlock)) {
                            plData.removePortalReturnLocation(destWorld.func_201675_m().func_186058_p());
                            failedPortalReturn = true;
                        }
                    }
                }
                if (currentWorld.func_180495_p(entity.func_180425_c()).func_177230_c() == this.getPortalBlock()) {
                    ChunkPos chunkPos = currentWorld.func_217349_x(entity.func_180425_c()).func_76632_l();
                    this.getCachedPortalMap().put(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b), entity.func_180425_c());
                }
                pos = null;
                if (failedPortalReturn) {
                    if (destWorld.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type() && !(this instanceof AncientCavernTeleporter)) {
                        pos = new BlockPos(0.5, 18.5, 0.5);
                    } else if (destWorld.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type() && !(this instanceof ImmortallisTeleporter)) {
                        pos = new BlockPos(-5, 20, 3);
                    }
                }
                if (pos == null) {
                    pos = this.findExistingPortal((World)destWorld, entity);
                }
                if (pos == null) {
                    pos = this.findSuitablePortalLocation((World)destWorld, entity);
                    pos = this.makePortal((World)destWorld, entity, pos);
                }
                this.placeInPortal((World)destWorld, entity, pos);
                ChunkPos chunkPos = destWorld.func_217349_x(pos).func_76632_l();
                this.getCachedPortalMap().put(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b), pos);
                if (plData == null) break block15;
                PortalCoordinatesContainer portalLoc = plData.getPortalReturnLocation(destWorld.func_201675_m().func_186058_p());
                if (portalLoc != null && (returnPortalLoc = plData.getPortalReturnLocation(entity.field_70170_p.func_201675_m().func_186058_p())) != null && returnPortalLoc.fromDim == destWorld.func_201675_m().func_186058_p()) {
                    return entity instanceof ServerPlayerEntity ? this.customPlayerPlacementFunction((ServerPlayerEntity)entity, currentWorld, destWorld, false) : this.customEntityPlacementFunction(entity, currentWorld, destWorld, false);
                }
                if (portalLoc == null || entity.field_70170_p.func_201675_m().func_186058_p() == portalLoc.fromDim) break block16;
                Vec3d vec3d = new Vec3d((Vec3i)portalLoc.asBlockPos());
                if (!(entity.func_195048_a(vec3d) > (double)((Integer)AoAConfig.SERVER.portalSearchRadius.get()).intValue())) break block15;
            }
            plData.setPortalReturnLocation(destWorld.func_201675_m().func_186058_p(), new PortalCoordinatesContainer(currentWorld.func_201675_m().func_186058_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
        return entity instanceof ServerPlayerEntity ? this.customPlayerPlacementFunction((ServerPlayerEntity)entity, currentWorld, destWorld, false) : this.customEntityPlacementFunction(entity, currentWorld, destWorld, false);
    }

    private Entity customPlayerPlacementFunction(ServerPlayerEntity entity, ServerWorld fromWorld, ServerWorld toWorld, boolean spawnPortal) {
        float yaw;
        double newPosX = entity.func_226277_ct_();
        double newPosY = entity.func_226278_cu_();
        double newPosZ = entity.func_226281_cx_();
        float pitch = entity.field_70125_A;
        float f2 = yaw = entity.field_70177_z;
        entity.field_70170_p.func_217381_Z().func_76320_a("moving");
        if (fromWorld.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && toWorld.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
            entity.field_193110_cw = entity.func_213303_ch();
        } else if (fromWorld.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && toWorld.func_201675_m().func_186058_p() == DimensionType.field_223229_c_) {
            BlockPos spawnLocation = toWorld.func_180504_m();
            newPosX = spawnLocation.func_177958_n();
            newPosY = spawnLocation.func_177956_o();
            newPosZ = spawnLocation.func_177952_p();
            yaw = 90.0f;
            pitch = 0.0f;
        }
        entity.func_70012_b(newPosX, newPosY, newPosZ, yaw, pitch);
        fromWorld.func_217381_Z().func_76319_b();
        fromWorld.func_217381_Z().func_76320_a("placing");
        double minX = Math.min(-2.9999872E7, toWorld.func_175723_af().func_177726_b() + 16.0);
        double minZ = Math.min(-2.9999872E7, toWorld.func_175723_af().func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, toWorld.func_175723_af().func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, toWorld.func_175723_af().func_177733_e() - 16.0);
        newPosX = MathHelper.func_151237_a((double)newPosX, (double)minX, (double)maxX);
        newPosZ = MathHelper.func_151237_a((double)newPosZ, (double)minZ, (double)maxZ);
        entity.func_70012_b(newPosX, newPosY, newPosZ, yaw, pitch);
        if (toWorld.func_201675_m().func_186058_p() == DimensionType.field_223229_c_) {
            int baseX = MathHelper.func_76128_c((double)entity.func_226277_ct_());
            int baseY = MathHelper.func_76128_c((double)entity.func_226278_cu_()) - 1;
            int baseZ = MathHelper.func_76128_c((double)entity.func_226281_cx_());
            for (int j1 = -2; j1 <= 2; ++j1) {
                for (int k1 = -2; k1 <= 2; ++k1) {
                    for (int l1 = -1; l1 < 3; ++l1) {
                        int i2 = baseX + k1;
                        int j2 = baseY + l1;
                        int k2 = baseZ + j1;
                        boolean flag = l1 < 0;
                        toWorld.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            entity.func_70012_b((double)baseX, (double)baseY, (double)baseZ, yaw, 0.0f);
            entity.func_213317_d(Vec3d.field_186680_a);
        } else if (spawnPortal && !toWorld.func_85176_s().func_222268_a((Entity)entity, f2)) {
            toWorld.func_85176_s().func_85188_a((Entity)entity);
            toWorld.func_85176_s().func_222268_a((Entity)entity, f2);
        }
        fromWorld.func_217381_Z().func_76319_b();
        entity.func_70029_a((World)toWorld);
        toWorld.func_217447_b(entity);
        entity.func_213846_b(fromWorld);
        entity.field_71135_a.func_147364_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), yaw, pitch);
        return entity;
    }

    private Entity customEntityPlacementFunction(Entity entity, ServerWorld fromWorld, ServerWorld toWorld, boolean spawnPortal) {
        BlockPos pos;
        Vec3d motion = entity.func_213322_ci();
        float portalRotation = 0.0f;
        if (fromWorld.func_201675_m().func_186058_p() == DimensionType.field_223229_c_ && toWorld.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            pos = toWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, toWorld.func_175694_M());
        } else if (toWorld.func_201675_m().func_186058_p() == DimensionType.field_223229_c_) {
            pos = toWorld.func_180504_m();
        } else {
            double posX = entity.func_226277_ct_();
            double posZ = entity.func_226281_cx_();
            double minX = Math.min(-2.9999872E7, toWorld.func_175723_af().func_177726_b() + 16.0);
            double minZ = Math.min(-2.9999872E7, toWorld.func_175723_af().func_177736_c() + 16.0);
            double maxX = Math.min(2.9999872E7, toWorld.func_175723_af().func_177728_d() - 16.0);
            double maxZ = Math.min(2.9999872E7, toWorld.func_175723_af().func_177733_e() - 16.0);
            posX = MathHelper.func_151237_a((double)posX, (double)minX, (double)maxX);
            posZ = MathHelper.func_151237_a((double)posZ, (double)minZ, (double)maxZ);
            Vec3d portalLocation = entity.func_181014_aG();
            pos = new BlockPos(posX, entity.func_226278_cu_(), posZ);
            if (spawnPortal) {
                BlockPattern.PortalInfo portalInfo = toWorld.func_85176_s().func_222272_a(pos, motion, entity.func_181012_aH(), portalLocation.field_72450_a, portalLocation.field_72448_b, entity instanceof PlayerEntity);
                if (portalInfo == null) {
                    return null;
                }
                pos = new BlockPos(portalInfo.field_222505_a);
                motion = portalInfo.field_222506_b;
                portalRotation = portalInfo.field_222507_c;
            }
        }
        entity.field_70170_p.func_217381_Z().func_219895_b("reloading");
        Entity newEntity = entity.func_200600_R().func_200721_a((World)toWorld);
        newEntity.func_180432_n(entity);
        newEntity.func_174828_a(pos, entity.field_70177_z + portalRotation, entity.field_70125_A);
        newEntity.func_213317_d(motion);
        toWorld.func_217460_e(newEntity);
        return newEntity;
    }

    public BlockPos findExistingPortal(World world, Entity entity) {
        int z;
        int x;
        int posX = (int)Math.floor(entity.func_226277_ct_());
        int posY = (int)Math.floor(entity.func_226278_cu_());
        int posZ = (int)Math.floor(entity.func_226281_cx_());
        ChunkPos chunkPos = world.func_217349_x(new BlockPos(posX, posY, posZ)).func_76632_l();
        Long chunkPosLong = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
        HashMap<Long, BlockPos> cachedPortalMap = this.getCachedPortalMap();
        if (cachedPortalMap.containsKey(chunkPosLong)) {
            BlockPos pos = cachedPortalMap.get(chunkPosLong);
            if (world.func_180495_p(pos).func_177230_c() == this.getPortalBlock()) {
                return cachedPortalMap.get(chunkPosLong);
            }
            cachedPortalMap.remove(chunkPosLong);
        }
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        int searchRadius = (Integer)AoAConfig.SERVER.portalSearchRadius.get();
        int worldHeight = world.func_72940_L();
        if (posY >= worldHeight) {
            posY = 65;
        }
        if (world.func_180495_p((BlockPos)checkPos.func_181079_c(posX, posY, posZ)).func_177230_c() == this.getPortalBlock()) {
            while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() == this.getPortalBlock()) {
            }
            IChunk chunk = world.func_217349_x((BlockPos)checkPos.func_189536_c(Direction.UP));
            cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.func_76632_l().func_180333_d(), (int)chunk.func_76632_l().func_180333_d()), (BlockPos)checkPos);
            return checkPos;
        }
        for (int i = 1; i <= searchRadius; ++i) {
            for (int y = -i; y <= i; y += i * 2) {
                int y2 = posY + y;
                if (y2 < 0 || y2 >= worldHeight) continue;
                int xNeg = -1;
                for (int x2 = 0; x2 <= i; ++x2) {
                    int x22 = posX + x2 * xNeg;
                    if (xNeg == 1 && x2 != 0) {
                        --x2;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z2 = 0; z2 <= i; ++z2) {
                        int z22 = posZ + z2 * zNeg;
                        if (zNeg == 1 && z2 != 0) {
                            --z2;
                        }
                        zNeg *= -1;
                        checkPos.func_181079_c(x22, y2, z22);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        IChunk chunk = world.func_217349_x((BlockPos)checkPos.func_189536_c(Direction.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.func_76632_l().func_180334_c(), (int)chunk.func_76632_l().func_180333_d()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
            int yNeg = -1;
            for (int y = 0; y <= i - 1; ++y) {
                int y2 = posY + y * yNeg;
                if (y2 < 0 || y2 >= worldHeight) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z3 = 0; z3 <= i; ++z3) {
                    int z2 = posZ + z3 * zNeg;
                    if (zNeg == 1 && z3 != 0) {
                        --z3;
                    }
                    zNeg *= -1;
                    for (int x3 = -i; x3 <= i; x3 += i * 2) {
                        int x2 = posX + x3;
                        checkPos.func_181079_c(x2, y2, z2);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        IChunk chunk = world.func_217349_x((BlockPos)checkPos.func_189536_c(Direction.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.func_76632_l().func_180334_c(), (int)chunk.func_76632_l().func_180333_d()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
                int xNeg = 1;
                for (int x4 = 1; x4 <= i - 1; ++x4) {
                    int x2 = posX + x4 * xNeg;
                    if (xNeg == 1 && x4 != 0) {
                        --x4;
                    }
                    xNeg *= -1;
                    for (int z4 = -i; z4 <= i; z4 += i * 2) {
                        int z2 = posZ + z4;
                        checkPos.func_181079_c(x2, y2, z2);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        IChunk chunk = world.func_217349_x((BlockPos)checkPos.func_189536_c(Direction.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.func_76632_l().func_180334_c(), (int)chunk.func_76632_l().func_180333_d()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, posY - searchRadius, z);
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() != this.getPortalBlock() && checkPos.func_177956_o() >= 0) {
                }
                if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.DOWN)).func_177230_c() == this.getPortalBlock()) {
                }
                return checkPos.func_177981_b(2).func_185334_h();
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, posY + searchRadius, z);
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(Direction.UP)).func_177230_c() != this.getPortalBlock() && checkPos.func_177956_o() < worldHeight) {
                }
                if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                return checkPos.func_177981_b(1).func_185334_h();
            }
        }
        return null;
    }

    public BlockPos findSuitablePortalLocation(World world, Entity entity) {
        int y2;
        int z2;
        int x2;
        int y;
        int z;
        int x;
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        int posX = (int)Math.floor(entity.func_226277_ct_());
        int posY = (int)Math.floor(entity.func_226278_cu_());
        int posZ = (int)Math.floor(entity.func_226281_cx_());
        BlockPos planBPos = null;
        int searchRadius = (Integer)AoAConfig.SERVER.portalSearchRadius.get();
        int worldHeight = world.func_72940_L();
        if (posY >= worldHeight) {
            posY = 65;
        }
        boolean cleanSpawn = true;
        for (x = posX - 2; x <= posX + 2 && cleanSpawn; ++x) {
            for (z = posZ - 2; z <= posZ + 2 && cleanSpawn; ++z) {
                for (y = posY + 1; y <= posY + 6 && cleanSpawn; ++y) {
                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x, y, z))) continue;
                    cleanSpawn = false;
                }
            }
        }
        if (cleanSpawn) {
            if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(posX, posY, posZ))) {
                return checkPos.func_181079_c(posX, posY + 2, posZ).func_185334_h();
            }
            planBPos = checkPos.func_181079_c(posX, posY + 2, posZ).func_185334_h();
        }
        for (int i = 1; i <= searchRadius; ++i) {
            int y3;
            int z3;
            int x3;
            for (int y4 = -i; y4 <= i; y4 += i * 2) {
                int y22 = posY + y4;
                if (y22 < 0 || y22 >= worldHeight) continue;
                int xNeg = -1;
                for (int x4 = 0; x4 <= i; ++x4) {
                    int x22 = posX + x4 * xNeg;
                    if (xNeg == 1 && x4 != 0) {
                        --x4;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z4 = 0; z4 <= i; ++z4) {
                        int z22 = posZ + z4 * zNeg;
                        if (zNeg == 1 && z4 != 0) {
                            --z4;
                        }
                        zNeg *= -1;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x22, y22, z22))) {
                            cleanSpawn = true;
                            for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x22, y22 + 2, z22).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x22, y22 + 2, z22).func_185334_h();
                    }
                }
            }
            int yNeg = -1;
            for (y = 0; y <= i - 1; ++y) {
                int y23 = posY + y * yNeg;
                if (y23 < 0 || y23 >= worldHeight) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z5 = 0; z5 <= i; ++z5) {
                    int z23 = posZ + z5 * zNeg;
                    if (zNeg == 1 && z5 != 0) {
                        --z5;
                    }
                    zNeg *= -1;
                    for (int x5 = -i; x5 <= i; x5 += i * 2) {
                        int x23 = posX + x5;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x23, y23, z23))) {
                            cleanSpawn = true;
                            for (x3 = x23 - 2; x3 <= x23 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z23 - 2; z3 <= z23 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y23 + 1; y3 <= y23 + 6 && cleanSpawn; ++y3) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x23, y23 + 2, z23).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x23 - 2; x3 <= x23 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z23 - 2; z3 <= z23 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y23 + 1; y3 <= y23 + 6 && cleanSpawn; ++y3) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x23, y23 + 2, z23).func_185334_h();
                    }
                }
                int xNeg = 1;
                for (int x6 = 1; x6 <= i - 1; ++x6) {
                    int x24 = posX + x6 * xNeg;
                    if (xNeg == 1 && x6 != 0) {
                        --x6;
                    }
                    xNeg *= -1;
                    for (int z6 = -i; z6 <= i; z6 += i * 2) {
                        int y32;
                        int z32;
                        int x32;
                        int z24 = posZ + z6;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x24, y23, z24))) {
                            cleanSpawn = true;
                            for (x32 = x24 - 2; x32 <= x24 + 2 && cleanSpawn; ++x32) {
                                for (z32 = z24 - 2; z32 <= z24 + 2 && cleanSpawn; ++z32) {
                                    for (y32 = y23 + 1; y32 <= y23 + 6 && cleanSpawn; ++y32) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x32, y32, z32))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x24, y23 + 2, z24).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x32 = x24 - 2; x32 <= x24 + 2 && cleanSpawn; ++x32) {
                            for (z32 = z24 - 2; z32 <= z24 + 2 && cleanSpawn; ++z32) {
                                for (y32 = y23 + 1; y32 <= y23 + 6 && cleanSpawn; ++y32) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x32, y32, z32))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x24, y23 + 2, z24).func_185334_h();
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, posY - searchRadius, z);
                while (world.func_175623_d((BlockPos)checkPos.func_189536_c(Direction.DOWN)) && checkPos.func_177956_o() >= 0) {
                }
                y = checkPos.func_177956_o();
                cleanSpawn = true;
                for (x2 = x - 2; x2 <= x + 2 && cleanSpawn; ++x2) {
                    for (z2 = z - 2; z2 <= z + 2 && cleanSpawn; ++z2) {
                        for (y2 = y + 1; y2 <= y + 6 && cleanSpawn; ++y2) {
                            if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x2, y2, z2))) continue;
                            cleanSpawn = false;
                        }
                    }
                }
                if (!cleanSpawn || y < 0) continue;
                return checkPos.func_181079_c(x, y + 2, z).func_185334_h();
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, worldHeight - 3, z);
                while (world.func_175623_d((BlockPos)checkPos.func_189536_c(Direction.DOWN)) && checkPos.func_177956_o() >= posY + searchRadius) {
                }
                y = checkPos.func_177956_o();
                cleanSpawn = true;
                for (x2 = x - 2; x2 <= x + 2 && cleanSpawn; ++x2) {
                    for (z2 = z - 2; z2 <= z + 2 && cleanSpawn; ++z2) {
                        for (y2 = y + 1; y2 <= y + 6 && cleanSpawn; ++y2) {
                            if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x2, y2, z2))) continue;
                            cleanSpawn = false;
                        }
                    }
                }
                if (!cleanSpawn) continue;
                return checkPos.func_181079_c(x, y + 2, z).func_185334_h();
            }
        }
        if (planBPos != null) {
            return planBPos;
        }
        return entity.func_180425_c().func_177981_b(2).func_185334_h();
    }

    public BlockPos makePortal(World world, Entity entity, BlockPos pos) {
        int x;
        int y;
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            return pos;
        }
        BlockPos returnPos = pos;
        pos = pos.func_177977_b();
        BlockState border = this.getBorderBlock().func_176223_P();
        BlockState portal = this.getPortalBlock().func_176223_P();
        Direction.Axis direction = EntityUtil.getDirectionFacing(entity, true).func_176740_k();
        if (direction == Direction.Axis.X) {
            portal = (BlockState)portal.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.X);
            for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                world.func_180501_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z), border, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, z), border, 0);
            }
            for (y = pos.func_177956_o() + 1; y <= pos.func_177956_o() + 4; ++y) {
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 2), border, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 2), border, 0);
            }
        } else {
            portal = (BlockState)portal.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.Z);
            for (x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                world.func_180501_a(new BlockPos(x, pos.func_177956_o(), pos.func_177952_p()), border, 0);
                world.func_180501_a(new BlockPos(x, pos.func_177956_o() + 5, pos.func_177952_p()), border, 0);
            }
            for (y = pos.func_177956_o() + 1; y <= pos.func_177956_o() + 4; ++y) {
                world.func_180501_a(new BlockPos(pos.func_177958_n() - 2, y, pos.func_177952_p()), border, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p()), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p()), portal, 0);
                world.func_180501_a(new BlockPos(pos.func_177958_n() + 2, y, pos.func_177952_p()), border, 0);
            }
        }
        pos = pos.func_177977_b();
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.func_177982_a(x, 0, z);
                if (world.func_180495_p(checkPos).func_224755_d((IBlockReader)world, checkPos, Direction.UP)) continue;
                this.makePortalPlatformAndDecorate(world, pos, direction);
                return returnPos;
            }
        }
        return returnPos;
    }

    public void makePortalPlatformAndDecorate(World world, BlockPos pos, Direction.Axis direction) {
        BlockState border = this.getBorderBlock().func_176223_P();
        for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
            for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                world.func_175656_a(new BlockPos(x, pos.func_177956_o(), z), border);
            }
        }
    }

    public void placeInPortal(World world, Entity entity, BlockPos pos) {
        entity.func_213293_j(0.0, 0.0, 0.0);
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        } else {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        }
    }
}

