/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.misc;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;

public class PortalFloaterParticleType
extends ParticleType<Data> {
    public PortalFloaterParticleType(boolean alwaysShow) {
        super(alwaysShow, Data.DESERIALIZER);
    }

    public static class Data
    implements IParticleData {
        private final ParticleType<Data> particleType;
        public final BlockPos portalPos;
        public final float red;
        public final float green;
        public final float blue;
        public final float alpha;
        public static final IParticleData.IDeserializer<Data> DESERIALIZER = new IParticleData.IDeserializer<Data>(){

            public Data deserialize(ParticleType<Data> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int x = reader.readInt();
                reader.expect(' ');
                int y = reader.readInt();
                reader.expect(' ');
                int z = reader.readInt();
                reader.expect(' ');
                float red = (float)reader.readDouble();
                reader.expect(' ');
                float green = (float)reader.readDouble();
                reader.expect(' ');
                float blue = (float)reader.readDouble();
                reader.expect(' ');
                float alpha = (float)reader.readDouble();
                return new Data(particleType, new BlockPos(x, y, z), red, green, blue, alpha);
            }

            public Data read(ParticleType<Data> particleType, PacketBuffer buffer) {
                return new Data(particleType, buffer.func_179259_c(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Data(ParticleType<Data> particleType, BlockPos portalPos, int colour) {
            this(particleType, portalPos, (float)(colour >> 16) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, (float)(colour >> 24) / 255.0f);
        }

        public Data(ParticleType<Data> particleType, BlockPos portalPos, float red, float green, float blue, float alpha) {
            this.particleType = particleType;
            this.portalPos = portalPos;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha == 0.0f ? 1.0f : alpha;
        }

        public ParticleType<?> func_197554_b() {
            return this.particleType;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.func_179255_a(this.portalPos);
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
        }
    }
}

