/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.resourcemanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.util.FileUtil;
import org.apache.logging.log4j.Level;

public class BestiaryManager
implements ISelectiveResourceReloadListener {
    public static final HashMap<ResourceLocation, String> BESTIARY = new HashMap();

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            try {
                BESTIARY.clear();
                Minecraft mc = Minecraft.func_71410_x();
                String langCode = mc.field_71474_y.field_74363_ab;
                if (mc.func_135016_M().func_135041_c() != null) {
                    langCode = mc.func_135016_M().func_135041_c().getCode();
                }
                for (ResourceLocation resourceLocation : resourceManager.func_199003_a("bestiary/" + langCode, path -> path.endsWith(".txt"))) {
                    for (IResource resource : resourceManager.func_199004_b(resourceLocation)) {
                        String relativePath = resource.func_199029_a().func_110623_a().substring(15);
                        String[] pathParts = relativePath.split("/");
                        if (pathParts.length < 2) {
                            Logging.logMessage(Level.DEBUG, "Invalid resource path for bestiary entry, skipping. " + relativePath);
                            continue;
                        }
                        ResourceLocation entryId = new ResourceLocation(pathParts[0], pathParts[1].substring(0, pathParts[1].length() - 4));
                        BESTIARY.put(entryId, FileUtil.bufferedReaderToString(new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8))));
                    }
                }
            }
            catch (IOException ex) {
                Logging.logMessage(Level.ERROR, "Failed to retrieve AoA3 Bestiary resources, skipping.", ex);
            }
        }
    }

    @Nullable
    public IResourceType getResourceType() {
        return VanillaResourceType.LANGUAGES;
    }
}

