/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tslat.aoa3.event.GlobalEvents;

public class AoAScheduler {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final HashSet<Runnable> scheduledTasks = new HashSet();
    private static final HashMultimap<Integer, Runnable> scheduledSynchTasks = HashMultimap.create();

    public static void scheduleRequiredAsyncTask(Runnable run, int time, TimeUnit unit) {
        scheduler.schedule(run, (long)time, unit);
        scheduledTasks.add(run);
    }

    public static void scheduleSyncronisedTask(Runnable run, int ticks) {
        scheduledSynchTasks.put((Object)(GlobalEvents.tick + ticks), (Object)run);
    }

    public static void scheduleAsyncTask(Runnable run, int time, TimeUnit unit) {
        scheduler.schedule(run, (long)time, unit);
    }

    public static void serverShutdownTasks() {
        for (Runnable task : scheduledTasks) {
            task.run();
        }
    }

    public static void handleSyncScheduledTasks(int tick) {
        if (scheduledSynchTasks.containsKey((Object)tick)) {
            Iterator tasks = scheduledSynchTasks.get((Object)tick).iterator();
            while (tasks.hasNext()) {
                ((Runnable)tasks.next()).run();
                tasks.remove();
            }
        }
    }
}

