/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.entity.boss.CreepEntity;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.WorldUtil;

public class CreepSpawnTask
implements Runnable {
    private final World world;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private int currentCorner;
    private int count = 0;

    public CreepSpawnTask(World w, double centerX, double centerY, double centerZ, int startingPosition) {
        this.world = w;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.currentCorner = startingPosition;
    }

    @Override
    public void run() {
        double x = this.centerX;
        double z = this.centerZ;
        switch (this.currentCorner) {
            case 0: {
                x += 9.0;
                z += 9.0;
                break;
            }
            case 1: {
                x -= 9.0;
                z += 9.0;
                break;
            }
            case 2: {
                x -= 9.0;
                z -= 9.0;
                break;
            }
            case 3: {
                x += 9.0;
                z -= 9.0;
            }
        }
        WorldUtil.createExplosion(null, this.world, x, this.centerY, z, 1.5f, WorldUtil.checkGameRule(this.world, AoAGameRules.STRONGER_MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        ++this.count;
        if (this.count >= 4) {
            CreepEntity creep = new CreepEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CREEP.get()), this.world);
            creep.func_70107_b(x, this.centerY, z);
            this.world.func_217376_c((Entity)creep);
            return;
        }
        ++this.currentCorner;
        if (this.currentCorner > 3) {
            this.currentCorner = 0;
        }
        this.schedule(2, TimeUnit.SECONDS);
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

