/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.async;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.KrorEntity;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerUtil;

public class KrorSpawnTask
implements Runnable {
    private final ServerPlayerEntity player;
    private final World world;
    private final BlockPos chargingTablePos;
    private int chargedAmount = 0;

    public KrorSpawnTask(ServerPlayerEntity player, BlockPos pos) {
        this.player = player;
        this.world = player.field_70170_p;
        this.chargingTablePos = pos;
    }

    @Override
    public void run() {
        if (this.player.field_70170_p != this.world || this.player.func_70092_e((double)this.chargingTablePos.func_177958_n(), (double)this.chargingTablePos.func_177956_o(), (double)this.chargingTablePos.func_177952_p()) > 100.0) {
            this.player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.kror.tooFar"));
            return;
        }
        if (this.world.func_175659_aa() == Difficulty.PEACEFUL) {
            this.player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.spawnBoss.difficultyFail"));
            return;
        }
        if (this.world.func_180495_p(this.chargingTablePos).func_177230_c() != AoABlocks.CHARGING_TABLE.get()) {
            return;
        }
        if (this.chargedAmount < 200) {
            if (PlayerUtil.consumeResource(this.player, Resources.ENERGY, 20.0f, false)) {
                this.chargedAmount += 20;
                ((ServerWorld)this.world).func_195598_a((IParticleData)ParticleTypes.field_197624_q, (double)this.chargingTablePos.func_177958_n() + 0.5, (double)this.chargingTablePos.func_177956_o() + 0.9, (double)this.chargingTablePos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerWorld)this.world).func_195598_a((IParticleData)ParticleTypes.field_197624_q, this.player.func_226277_ct_(), this.player.func_174813_aQ().field_72337_e + 0.5, this.player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.schedule(1, TimeUnit.SECONDS);
            } else {
                PlayerUtil.notifyPlayerOfInsufficientResources(this.player, Resources.ENERGY, 20.0f);
            }
        } else {
            KrorEntity kror = new KrorEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.KROR.get()), this.world);
            int i = 0;
            kror.func_70107_b((double)this.chargingTablePos.func_177958_n() - 0.5, this.chargingTablePos.func_177956_o(), (double)this.chargingTablePos.func_177952_p() - 0.5 + 10.0);
            while (this.world.func_72829_c(kror.func_174813_aQ())) {
                Random rand = kror.func_70681_au();
                kror.func_70107_b(kror.func_226277_ct_() + (double)rand.nextInt(20) - 10.0, kror.func_226278_cu_(), kror.func_226281_cx_() + (double)rand.nextInt(20) - 10.0);
                if (++i <= 64) continue;
                this.player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.spawnBoss.noSpace"));
                return;
            }
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.kror.spawn", this.player.func_145748_c_().func_150254_d()), this.world, this.player.func_180425_c(), 50);
            this.world.func_217376_c((Entity)kror);
            kror.func_70624_b((LivingEntity)this.player);
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

