/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.tslat.aoa3.block.functional.light.LampBlock;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.ShadowlordEntity;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ShadowlordSpawnTask
implements Runnable {
    private final PlayerEntity player;
    private final BlockPos altarPosition;
    private boolean spawning = false;
    private boolean spawned = false;

    public ShadowlordSpawnTask(PlayerEntity player, BlockPos altarPosition) {
        this.player = player;
        this.altarPosition = altarPosition;
    }

    @Override
    public void run() {
        if (this.spawned) {
            for (int x = -2; x <= 2; x += 4) {
                for (int z = -2; z <= 2; z += 4) {
                    BlockPos pos = this.altarPosition.func_177982_a(x, 1, z);
                    Block block = this.player.field_70170_p.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof LampBlock)) continue;
                    this.player.field_70170_p.func_175656_a(pos, (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)LampBlock.field_196502_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)LampBlock.TOGGLEABLE, (Comparable)Boolean.valueOf(false)));
                }
            }
        } else if (this.spawning) {
            this.spawned = true;
            ShadowlordEntity shadowlord = new ShadowlordEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SHADOWLORD.get()), this.player.field_70170_p);
            shadowlord.func_70012_b(this.altarPosition.func_177958_n(), this.altarPosition.func_177956_o() + 3, this.altarPosition.func_177952_p(), 0.0f, 0.0f);
            this.player.field_70170_p.func_217376_c((Entity)shadowlord);
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.shadowlord.spawn", this.player.func_145748_c_().func_150254_d()), this.player.field_70170_p, this.player.func_180425_c(), 50);
            this.schedule(5, TimeUnit.SECONDS);
        } else {
            for (int x = -2; x <= 2; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos pos = this.altarPosition.func_177982_a(x, y, z);
                        BlockState state = this.player.field_70170_p.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (!(block instanceof LampBlock) || !((Boolean)state.func_177229_b((IProperty)LampBlock.field_196502_a)).booleanValue()) continue;
                        this.player.field_70170_p.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LampBlock.field_196502_a, (Comparable)Boolean.valueOf(false)), 2);
                        this.schedule(2, TimeUnit.SECONDS);
                        this.player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
                        return;
                    }
                }
            }
            this.spawning = true;
            this.schedule(1, TimeUnit.SECONDS);
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

