/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.sync;

import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class UltimatumStaffTask
implements Runnable {
    private final int startingTick = GlobalEvents.tick;
    private final LivingEntity shooter;
    private final LivingEntity target;
    private final BlockPos shooterPos;
    private final BlockPos targetPos;
    private final float shooterStartHealth;
    private final float targetStartHealth;
    private boolean targetTurn = true;

    public UltimatumStaffTask(LivingEntity shooter, LivingEntity target) {
        this.shooter = shooter;
        this.target = target;
        this.shooterPos = shooter.func_180425_c();
        this.targetPos = target.func_180425_c();
        this.shooterStartHealth = shooter.func_110143_aJ();
        this.targetStartHealth = target.func_110143_aJ();
        target.func_213293_j(0.0, 0.0, 0.0);
        shooter.func_213293_j(0.0, 0.0, 0.0);
        EntityUtil.removePotions(target, Effects.field_76428_l);
        EntityUtil.removePotions(shooter, Effects.field_76428_l);
        EntityUtil.applyPotions(Arrays.asList(target, shooter), new PotionUtil.EffectBuilder(Effects.field_76421_d, 210).level(100).hideParticles(), new PotionUtil.EffectBuilder(Effects.field_76437_t, 210).level(50).hideParticles(), new PotionUtil.EffectBuilder(Effects.field_76429_m, 210).level(5).hideParticles(), new PotionUtil.EffectBuilder(Effects.field_76439_r, 510).hideParticles(), new PotionUtil.EffectBuilder(Effects.field_76440_q, 210).hideParticles(), new PotionUtil.EffectBuilder(Effects.field_188424_y, 210).level(-1).hideParticles());
    }

    @Override
    public void run() {
        if (this.shooter == null || this.target == null || this.shooter.field_70170_p.field_72995_K || !this.shooter.func_180425_c().equals((Object)this.shooterPos) || !this.target.func_180425_c().equals((Object)this.targetPos)) {
            this.resetStates();
            return;
        }
        float healthPercent = 1.0f - (float)(GlobalEvents.tick - this.startingTick) / 200.0f;
        float targetPostHealth = this.targetStartHealth * healthPercent;
        float shooterPostHealth = this.shooterStartHealth * healthPercent;
        if (this.targetTurn) {
            if (this.target.func_110143_aJ() == 0.0f) {
                this.resetStates();
                return;
            }
            if (targetPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.dealMagicDamage(null, this.shooter, (Entity)this.target, this.target.func_110143_aJ() - targetPostHealth, true);
                this.target.func_213293_j(0.0, 0.0, 0.0);
            } else {
                this.target.func_70606_j(targetPostHealth);
            }
            ((ServerWorld)this.shooter.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, this.target.func_226277_ct_(), this.target.func_226278_cu_() + (double)this.target.func_213302_cg(), this.target.func_226281_cx_(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        } else if (!(this.shooter instanceof PlayerEntity) || !((PlayerEntity)this.shooter).func_184812_l_()) {
            if (shooterPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.dealSelfHarmDamage(this.shooter, this.shooter.func_110143_aJ() - shooterPostHealth);
            } else {
                this.shooter.func_70606_j(shooterPostHealth);
            }
            ((ServerWorld)this.shooter.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, this.shooter.func_226277_ct_(), this.shooter.func_226278_cu_() + (double)this.shooter.func_213302_cg(), this.shooter.func_226281_cx_(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        }
        this.targetTurn = !this.targetTurn;
        AoAScheduler.scheduleSyncronisedTask(this, 1);
    }

    private void resetStates() {
        if (this.target.func_110143_aJ() > 0.0f) {
            EntityUtil.removePotions(this.target, Effects.field_76440_q, Effects.field_76429_m, Effects.field_76437_t, Effects.field_76421_d, Effects.field_188424_y, Effects.field_76439_r);
        }
        if (this.shooter.func_110143_aJ() > 0.0f) {
            EntityUtil.removePotions(this.shooter, Effects.field_76440_q, Effects.field_76429_m, Effects.field_76437_t, Effects.field_76421_d, Effects.field_188424_y, Effects.field_76439_r);
        }
    }
}

