/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.library.misc.MutableSupplier;

public abstract class BlockUtil {
    public static final float UNBREAKABLE_HARDNESS = -1.0f;
    public static final float UNBREAKABLE_RESISTANCE = 1.0E9f;

    public static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance) {
        return BlockUtil.generateBlockProperties(material, mapColour, hardness, resistance, null, null, 0, -1);
    }

    public static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance, int lightLevel) {
        return BlockUtil.generateBlockProperties(material, mapColour, hardness, resistance, null, null, lightLevel, -1);
    }

    public static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance, ToolType harvestTool, int harvestLevel) {
        return BlockUtil.generateBlockProperties(material, mapColour, hardness, resistance, harvestTool, null, 0, harvestLevel);
    }

    public static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance, @Nullable SoundType soundType) {
        return BlockUtil.generateBlockProperties(material, mapColour, hardness, resistance, null, soundType, 0, -1);
    }

    public static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance, @Nullable ToolType harvestTool, @Nullable SoundType soundType, int lightLevel, int harvestLevel) {
        Block.Properties properties = Block.Properties.func_200949_a((Material)material, (MaterialColor)mapColour);
        properties.func_200948_a(hardness, resistance);
        properties.harvestLevel(harvestLevel);
        properties.func_200951_a(lightLevel);
        if (hardness == -1.0f && resistance == 1.0E9f) {
            properties.func_222380_e();
        }
        if (harvestTool != null) {
            properties.harvestTool(harvestTool);
        }
        if (soundType != null) {
            properties.func_200947_a(soundType);
        } else if (material == null || material == Material.field_151576_e) {
            properties.func_200947_a(SoundType.field_185851_d);
        } else if (material == Material.field_151575_d) {
            properties.func_200947_a(SoundType.field_185848_a);
        } else if (material == Material.field_151592_s) {
            properties.func_200947_a(SoundType.field_185853_f);
        } else if (material == Material.field_151578_c) {
            properties.func_200947_a(SoundType.field_185849_b);
        } else if (material == Material.field_151585_k || material == Material.field_151577_b) {
            properties.func_200947_a(SoundType.field_185850_c);
        } else if (material == Material.field_151597_y || material == Material.field_151596_z) {
            properties.func_200947_a(SoundType.field_185856_i);
        } else if (material == Material.field_151595_p) {
            properties.func_200947_a(SoundType.field_185855_h);
        } else if (material == Material.field_151580_n) {
            properties.func_200947_a(SoundType.field_185854_g);
        }
        return properties;
    }

    public static RegistryObject<FlowingFluidBlock> createFluidBlock(String id, Material material, int colour, int viscosity, int density) {
        return BlockUtil.createFluidBlock(id, material, colour, viscosity, density, new ResourceLocation("block/water_still"), new ResourceLocation("block/water_flow"), new ResourceLocation("block/water_overlay"));
    }

    public static RegistryObject<FlowingFluidBlock> createFluidBlock(String id, Material material, int colour, int viscosity, int density, ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlay) {
        MutableSupplier sourceFluid = new MutableSupplier(null);
        MutableSupplier flowingFluid = new MutableSupplier(null);
        RegistryObject block = AoABlocks.BLOCKS.register(id, () -> new FlowingFluidBlock((Supplier)flowingFluid, Block.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        ForgeFlowingFluid.Properties fluidProperties = new ForgeFlowingFluid.Properties(sourceFluid, flowingFluid, FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture).overlay(overlay).translationKey("block.aoa3." + id).color(colour).viscosity(viscosity).density(density)).bucket((Supplier)AoAItems.ITEMS.register(id + "_bucket", () -> new BucketItem((Supplier)sourceFluid, new Item.Properties().func_200916_a(AoAItemGroups.MISC_ITEMS).func_200917_a(16)))).block((Supplier)block);
        sourceFluid.update(AoABlocks.FLUIDS.register(id, () -> new ForgeFlowingFluid.Source(fluidProperties)));
        flowingFluid.update(AoABlocks.FLUIDS.register(id + "_flowing", () -> new ForgeFlowingFluid.Flowing(fluidProperties)));
        return block;
    }
}

