/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.hud.toasts.LevelRequirementToast;
import net.tslat.aoa3.client.gui.hud.toasts.ResourceRequirementToast;
import net.tslat.aoa3.client.gui.hud.toasts.TributeRequirementToast;
import net.tslat.aoa3.client.gui.realmstone.BlankRealmstoneScreen;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.mob.greckon.SilencerEntity;
import net.tslat.aoa3.item.misc.WornBook;
import net.tslat.aoa3.library.resourcemanager.BestiaryManager;
import net.tslat.aoa3.library.resourcemanager.GuidesManager;
import net.tslat.aoa3.library.resourcemanager.MiscTextFileManager;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;

public abstract class ClientOperations {
    public static void displayWornBookGui() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack bookStack = player.func_184614_ca().func_77973_b() == AoAItems.WORN_BOOK.get() ? player.func_184614_ca() : player.func_184592_cb();
        Minecraft.func_71410_x().func_147108_a((Screen)new ReadBookScreen((ReadBookScreen.IBookInfo)new ReadBookScreen.WrittenBookInfo(WornBook.getBook(bookStack))));
    }

    public static void displayBlankRealmstoneGui() {
        Minecraft.func_71410_x().func_147108_a((Screen)new BlankRealmstoneScreen());
    }

    public static void addRecoil(float recoil, int firingTime) {
        RecoilRenderer.recoilTicks = Math.min(50, firingTime);
        RecoilRenderer.recoilTicksRemaining = Math.min(50, firingTime);
        RecoilRenderer.recoilAngle = recoil;
    }

    public static void spawnClientOnlyEntity(Entity entity) {
        if (entity.field_70170_p instanceof ClientWorld) {
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
            Runnable runnable = () -> ((ClientWorld)entity.field_70170_p).func_217411_a(entity.func_145782_y(), entity);
            if (!executor.func_213162_bc()) {
                executor.func_213165_a(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public static void removeClientOnlyEntity(Entity entity) {
        if (entity.field_70170_p instanceof ClientWorld) {
            ((ClientWorld)entity.field_70170_p).func_217413_d(entity.func_145782_y());
        }
    }

    public static void registerResourceListeners() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)mc.func_195551_G();
        resourceManager.func_219534_a((IFutureReloadListener)new GuidesManager());
        resourceManager.func_219534_a((IFutureReloadListener)new BestiaryManager());
        resourceManager.func_219534_a((IFutureReloadListener)new MiscTextFileManager());
    }

    public static void addToast(ToastPopupPacket.ToastPopupType type, Object subject, Object value) {
        switch (type) {
            case SKILL_REQUIREMENT: {
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new LevelRequirementToast((Skills)((Object)subject), (Integer)value));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.insufficientLevels", TextFormatting.RED, String.valueOf(value), StringUtil.toSentenceCase(subject.toString())));
                break;
            }
            case RESOURCE_REQUIREMENT: {
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ResourceRequirementToast((Resources)((Object)subject), ((Float)value).floatValue()));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.insufficientResource", TextFormatting.RED, NumberUtil.roundToNthDecimalPlace(((Float)value).floatValue(), 2), StringUtil.toSentenceCase(subject.toString())));
                break;
            }
            case TRIBUTE_REQUIREMENT: {
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new TributeRequirementToast((Deities)((Object)subject), (Integer)value));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.insufficientTribute", TextFormatting.RED, String.valueOf(value), StringUtil.toSentenceCase(subject.toString())));
            }
        }
    }

    public static void doSilencerSilence(SilencerEntity silencer) {
        if (!SilencerEntity.isClientNearby) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.func_147118_V().field_147694_f.func_188769_a(SoundCategory.MASTER) > 0.0f && silencer.func_70068_e((Entity)mc.field_71439_g) < 64.0) {
                SilencerEntity.isClientNearby = true;
                SilencerEntity.prevVolume = mc.func_147118_V().field_147694_f.func_188769_a(SoundCategory.MASTER);
                mc.func_147118_V().func_184399_a(SoundCategory.MASTER, 0.0f);
            }
        }
    }
}

