/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.tslat.aoa3.common.registration.AoAArmour;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.HunterUtil;

public abstract class DamageUtil {
    public static void doScaledKnockback(LivingEntity target, Entity attacker, float strength, double xRatio, double zRatio) {
        if (target instanceof PlayerEntity && !PlayerUtil.shouldPlayerBeAffected((PlayerEntity)target)) {
            return;
        }
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (Entity)attacker, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength() * (float)(1.0 - target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e());
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        target.field_70160_al = true;
        target.field_70133_I = true;
        float vec = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        Vec3d targetMotion = target.func_213322_ci();
        double motionX = targetMotion.func_82615_a() / 2.0 - xRatio / (double)vec * (double)strength;
        double motionZ = targetMotion.func_82616_c() / 2.0 - zRatio / (double)vec * (double)strength;
        double motionY = targetMotion.func_82617_b();
        if (target.field_70122_E) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        target.func_213317_d(new Vec3d(motionX, motionY, motionZ));
        target.field_70133_I = true;
    }

    public static void doBodySlamKnockback(LivingEntity target, Entity attacker, float xModifier, float yModifier, float zModifier) {
        double zVelocity;
        double yVelocity;
        if (target instanceof PlayerEntity && !PlayerUtil.shouldPlayerBeAffected((PlayerEntity)target)) {
            return;
        }
        Vec3d attackerVelocity = attacker.func_213322_ci();
        double xVelocity = attackerVelocity.func_82615_a() * (double)xModifier;
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (Entity)attacker, (float)((float)NumberUtil.average(xVelocity, yVelocity = attackerVelocity.func_82617_b() * (double)yModifier, zVelocity = attackerVelocity.func_82616_c() * (double)zModifier)), (double)xVelocity, (double)zVelocity);
        if (event.isCanceled()) {
            return;
        }
        double resist = 1.0;
        IAttributeInstance attrib = target.func_110148_a(SharedMonsterAttributes.field_111266_c);
        if (attrib != null) {
            resist -= attrib.func_111126_e();
        }
        target.func_70024_g(event.getRatioX() * resist, yVelocity * resist, event.getRatioZ() * resist);
        target.field_70133_I = true;
    }

    public static void killEntityCleanly(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            entity.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            entity.func_70106_y();
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        target.func_70097_a(new DamageSource("magic").func_76348_h().func_151518_m().func_82726_p(), ((LivingEntity)entity).func_110143_aJ());
        if (target.func_110143_aJ() > 0.0f) {
            target.func_70606_j(0.0f);
        }
    }

    public static boolean dealAoeDamage(@Nullable Entity indirectSource, LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        if (indirectSource != null) {
            damageSource = new IndirectEntityDamageSource("aoe", indirectSource, (Entity)attacker).func_82726_p();
        } else {
            DamageSource damageSource2 = damageSource = attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_76358_a((LivingEntity)attacker);
        }
        if (bypassProtections) {
            damageSource.func_76348_h();
            damageSource.func_151518_m();
        }
        if (target.func_180431_b(damageSource)) {
            return false;
        }
        if (target instanceof LivingEntity && !HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, false)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(damageSource, dmg);
    }

    public static boolean dealBlasterDamage(LivingEntity attacker, Entity target, Entity shot, float dmg, boolean bypassProtections) {
        IndirectEntityDamageSource damageSource = new IndirectEntityDamageSource("blaster", shot, (Entity)attacker);
        damageSource.func_82726_p();
        if (!(target instanceof PlayerEntity)) {
            damageSource.func_76348_h();
        }
        if (bypassProtections) {
            damageSource.func_151518_m();
            damageSource.func_76348_h();
        }
        if (target.func_180431_b((DamageSource)damageSource)) {
            return false;
        }
        if (target instanceof EnderDragonPartEntity || target instanceof EnderCrystalEntity) {
            return target.func_70097_a((DamageSource)damageSource, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        Vec3d targetMotion = target.func_213322_ci();
        boolean success = target.func_70097_a((DamageSource)damageSource, dmg);
        target.func_213317_d(targetMotion);
        target.field_70133_I = false;
        return success;
    }

    public static boolean dealMeleeDamage(LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        DamageSource damageSource2 = damageSource = attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_76358_a((LivingEntity)attacker);
        if (target.func_180431_b(damageSource)) {
            return false;
        }
        if (bypassProtections) {
            damageSource.func_76348_h();
            damageSource.func_151518_m();
        }
        if (target instanceof LivingEntity && !HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        boolean success = target.func_70097_a(damageSource, dmg);
        target.field_70172_ad = 0;
        return success;
    }

    public static boolean dealMagicDamage(@Nullable Entity indirectSource, LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        Object damageSource = indirectSource != null ? new IndirectEntityDamageSource("magic", indirectSource, (Entity)attacker) : (attacker instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)) : DamageSource.func_76358_a((LivingEntity)attacker));
        damageSource.func_82726_p();
        if (!(target instanceof PlayerEntity)) {
            damageSource.func_76348_h();
        }
        if (bypassProtections) {
            damageSource.func_151518_m();
        }
        if (target.func_180431_b(damageSource)) {
            return false;
        }
        if (target instanceof EnderDragonPartEntity || target instanceof EnderCrystalEntity) {
            return target.func_70097_a(damageSource, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(damageSource, dmg);
    }

    public static void dealSelfHarmDamage(LivingEntity target, float dmg) {
        if (target instanceof PlayerEntity && !PlayerUtil.shouldPlayerBeAffected((PlayerEntity)target)) {
            return;
        }
        if (target.func_110143_aJ() - dmg > 0.0f) {
            target.func_70606_j(target.func_110143_aJ() - dmg);
        } else {
            target.field_70172_ad = 0;
            target.func_70097_a(new DamageSource("selfharm").func_151518_m().func_76348_h(), dmg);
        }
    }

    public static boolean dealGunDamage(Entity target, LivingEntity attacker, ThrowableEntity bullet, float dmg) {
        boolean success;
        DamageSource source = new IndirectEntityDamageSource("gun", (Entity)bullet, (Entity)attacker).func_76349_b();
        if (target.func_180431_b(source)) {
            return false;
        }
        if (target instanceof EnderDragonPartEntity || target instanceof EnderCrystalEntity) {
            return target.func_70097_a(source, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        if (RandomUtil.percentChance(0.6f)) {
            Vec3d targetMotion = target.func_213322_ci();
            success = target.func_70097_a(source, dmg);
            target.func_213317_d(targetMotion);
            target.field_70133_I = false;
        } else {
            success = target.func_70097_a(source, dmg);
            target.field_70133_I = true;
        }
        return success;
    }

    public static boolean dealVulcaneDamage(LivingEntity target, PlayerEntity attacker, float dmg) {
        DamageSource source = DamageSource.func_76365_a((PlayerEntity)attacker).func_151518_m().func_76348_h();
        if (target.func_180431_b(source)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget(target, (Entity)attacker, false)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(source, dmg);
    }

    public static boolean dealRangedDamage(Entity target, LivingEntity attacker, Entity projectile, float dmg) {
        DamageSource source = DamageSource.func_76356_a((Entity)projectile, (Entity)attacker);
        if (target.func_180431_b(source)) {
            return false;
        }
        if (target instanceof EnderDragonPartEntity || target instanceof EnderCrystalEntity) {
            return target.func_70097_a(source, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        target.field_70133_I = true;
        return target.func_70097_a(source, dmg);
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.func_76346_g() != null && !source.func_76352_a() && !source.func_76355_l().equals("thrown") && !source.func_82725_o() && !source.func_94541_c() && !source.func_76347_k() && source.func_76364_f() == source.func_76346_g();
    }

    public static boolean isBlasterDamage(DamageSource source) {
        return source.func_76355_l().equals("blaster") && source.func_82725_o();
    }

    public static boolean isMagicDamage(DamageSource source, Entity target, float dmg) {
        return source.func_82725_o() && !source.func_76355_l().equals("blaster") && !source.func_76355_l().equals("thorns") && (!(target instanceof LivingEntity) || !DamageUtil.isPoisonDamage(source, target, dmg));
    }

    public static boolean isRangedDamage(DamageSource source, Entity target, float dmg) {
        return (source.func_76352_a() && !source.func_76355_l().equals("gun") || source.func_76355_l().equals("thrown")) && !DamageUtil.isMagicDamage(source, target, dmg);
    }

    public static boolean isGunDamage(DamageSource source) {
        return source.func_76355_l().equals("gun") && source.func_76352_a();
    }

    public static boolean isPoisonDamage(DamageSource source, Entity target, float dmg) {
        return source.func_82725_o() && source.func_76346_g() == null && !source.func_76355_l().equals("thorns") && target instanceof LivingEntity && ((LivingEntity)target).func_70644_a(Effects.field_76436_u) && dmg == 1.0f;
    }

    public static boolean isPhysicalDamage(DamageSource source, Entity target, float dmg) {
        return !DamageUtil.isPoisonDamage(source, target, dmg) && !source.func_82725_o() && !source.func_94541_c() && source != DamageSource.field_82727_n && source != DamageSource.field_76380_i && !source.func_76347_k() && source != DamageSource.field_76366_f;
    }

    public static boolean isEnvironmentalDamage(DamageSource source) {
        if (source.func_76346_g() != null || source.func_94541_c()) {
            return false;
        }
        switch (source.func_76355_l()) {
            case "onFire": 
            case "inFire": 
            case "cactus": 
            case "acid": 
            case "lightningBolt": 
            case "lava": 
            case "cramming": 
            case "inWall": 
            case "fallingBlock": 
            case "starve": 
            case "anvil": 
            case "outOfWorld": {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerEnvironmentallyProtected(ServerPlayerEntity player) {
        return PlayerUtil.isWearingFullSet(player, AdventArmour.Type.HAZMAT) || ((ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.HEAD.func_188454_b())).func_77973_b() == AoAArmour.FACE_MASK.get();
    }
}

