/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.FakePlayer;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.HunterUtil;

public abstract class EntityUtil {
    public static final AttributeModifier SPRINTING_SPEED_BOOST = new AttributeModifier(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"), "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    public static final AttributeModifier SLOW_FALLING = new AttributeModifier(UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA"), "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public static boolean isVulnerableEntity(Entity entity, @Nullable DamageSource source) {
        if (!(entity instanceof LivingEntity) || !entity.func_70089_S()) {
            return false;
        }
        if (source == null ? entity.func_190530_aW() : entity.func_180431_b(source)) {
            return false;
        }
        if (!(entity instanceof PlayerEntity)) {
            return true;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return PlayerUtil.shouldPlayerBeAffected(player);
    }

    public static boolean isHostileMob(Entity entity) {
        return entity instanceof IMob;
    }

    public static void healEntity(LivingEntity entity, float amount) {
        if (amount > 0.0f && entity.func_70089_S() && entity.func_110143_aJ() > 0.0f && entity.func_110143_aJ() < entity.func_110138_aP()) {
            entity.func_70691_i(amount);
        }
    }

    public static float getCurrentHealthPercent(LivingEntity entity) {
        return entity.func_110143_aJ() / entity.func_110138_aP();
    }

    public static boolean checkAboveHealthPercentThreshold(LivingEntity entity, float thresholdPercent) {
        if (entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) >= thresholdPercent;
    }

    public static boolean checkBelowHealthPercentThreshold(LivingEntity entity, float thresholdPercent) {
        if (entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) < thresholdPercent;
    }

    public static boolean isImmuneToSpecialAttacks(Entity target, LivingEntity attacker) {
        if (target instanceof LivingEntity && !HunterUtil.canAttackTarget((LivingEntity)target, (Entity)attacker, false)) {
            return true;
        }
        return target instanceof PlayerEntity || target instanceof WitherEntity || target instanceof EnderDragonEntity || !target.func_184222_aU() || target.func_190530_aW() || target instanceof LivingEntity && ((LivingEntity)target).func_110138_aP() > 500.0f;
    }

    public static float getAttackCooldown(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_184825_o(0.0f);
        }
        return 1.0f;
    }

    public static boolean isFlyingCreature(Entity entity) {
        return entity instanceof LivingEntity && (entity instanceof FlyingEntity || entity instanceof IFlyingAnimal);
    }

    public static void reapplyAttributeModifier(LivingEntity entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null) {
            if (instance.func_111127_a(modifier.func_111167_a()) != null) {
                instance.func_188479_b(modifier.func_111167_a());
            }
            instance.func_111121_a(modifier);
        }
    }

    public static void applyAttributeModifierSafely(LivingEntity entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && !instance.func_180374_a(modifier)) {
            instance.func_111121_a(modifier);
        }
    }

    public static void removeAttributeModifier(LivingEntity entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && instance.func_180374_a(modifier)) {
            instance.func_111124_b(modifier);
        }
    }

    public static void removeAttributeModifier(LivingEntity entity, IAttribute attribute, UUID modifierId) {
        AttributeModifier modifier;
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && (modifier = instance.func_111127_a(modifierId)) != null) {
            instance.func_111124_b(modifier);
        }
    }

    public static void pushEntityAway(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength) {
        Vec3d targetMotion = targetEntity.func_213322_ci();
        targetEntity.func_213293_j((targetEntity.func_226277_ct_() - centralEntity.func_226277_ct_()) * (double)strength + targetMotion.func_82615_a(), (targetEntity.func_226278_cu_() - centralEntity.func_226278_cu_()) * (double)strength + targetMotion.func_82617_b(), (targetEntity.func_226281_cx_() - centralEntity.func_226281_cx_()) * (double)strength + targetMotion.func_82616_c());
        targetEntity.field_70133_I = true;
    }

    public static void pullEntityIn(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength) {
        Vec3d targetMotion = targetEntity.func_213322_ci();
        targetEntity.func_213293_j((centralEntity.func_226277_ct_() - targetEntity.func_226277_ct_()) * (double)strength + targetMotion.func_82615_a(), (centralEntity.func_226278_cu_() - targetEntity.func_226278_cu_()) * (double)strength + targetMotion.func_82617_b(), (centralEntity.func_226281_cx_() - targetEntity.func_226281_cx_()) * (double)strength + targetMotion.func_82616_c());
        targetEntity.field_70133_I = true;
    }

    public static void applyPotions(Collection<? extends Entity> entities, PotionUtil.EffectBuilder ... effects) {
        for (Entity entity : entities) {
            EntityUtil.applyPotions(entity, effects);
        }
    }

    public static void applyPotions(Entity entity, PotionUtil.EffectBuilder ... effects) {
        if (!(entity instanceof LivingEntity) || !entity.func_70089_S() || entity.func_175149_v() || entity instanceof FakePlayer) {
            return;
        }
        boolean onlyBeneficial = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
        for (PotionUtil.EffectBuilder builder : effects) {
            if (onlyBeneficial && !builder.getEffect().func_188408_i()) continue;
            ((LivingEntity)entity).func_195064_c(builder.build());
        }
    }

    public static void removePotions(LivingEntity entity, Effect ... effects) {
        for (Effect effect : effects) {
            if (!entity.func_70644_a(effect)) continue;
            entity.func_195063_d(effect);
        }
    }

    public static boolean isPlayerLookingAtEntity(PlayerEntity pl, Entity target) {
        return EntityUtil.isPlayerLookingAt(pl, target.func_226277_ct_(), target.func_174813_aQ().field_72338_b + (double)target.func_213302_cg() / 2.0, target.func_226281_cx_()) && pl.func_70685_l(target);
    }

    public static boolean isPlayerLookingAt(PlayerEntity pl, double posX, double posY, double posZ) {
        Vec3d playerLookVec = pl.func_70040_Z().func_72432_b();
        Vec3d requiredLookVec = new Vec3d(posX - pl.func_226277_ct_(), posY - (pl.func_226278_cu_() + (double)pl.func_70047_e()), posZ - pl.func_226281_cx_());
        double requiredLookVecLength = requiredLookVec.func_72433_c();
        double vecDotProduct = playerLookVec.func_72430_b(requiredLookVec = requiredLookVec.func_72432_b());
        return vecDotProduct > 1.0 - 0.025 / requiredLookVecLength;
    }

    public static boolean isNaturalSpawnReason(SpawnReason reason) {
        return reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL;
    }

    @Nullable
    public static Vec3d preciseEntityInterceptCalculation(Entity impactedEntity, Entity impactingEntity, int granularity) {
        Vec3d vecVelocity = impactingEntity.func_213322_ci();
        double velocityX = vecVelocity.func_82615_a();
        double velocityY = vecVelocity.func_82617_b();
        double velocityZ = vecVelocity.func_82616_c();
        for (int i = 0; i < granularity; ++i) {
            double projectionX = velocityX * (double)(1.0f / (float)granularity) * (double)i;
            double projectionY = velocityY * (double)(1.0f / (float)granularity) * (double)i;
            double projectionZ = velocityZ * (double)(1.0f / (float)granularity) * (double)i;
            Vec3d initialVec = new Vec3d(impactingEntity.func_226277_ct_(), impactingEntity.func_226278_cu_(), impactingEntity.func_226281_cx_());
            Vec3d projectedVec = initialVec.func_72441_c(projectionX, projectionY, projectionZ);
            List entityList = impactingEntity.field_70170_p.func_72839_b(impactingEntity, impactingEntity.func_174813_aQ().func_72314_b(projectionX, projectionY, projectionZ));
            for (Entity entity : entityList) {
                Optional intercept;
                if (entity != impactedEntity || !(intercept = entity.func_174813_aQ().func_216365_b(initialVec, projectedVec)).isPresent()) continue;
                return (Vec3d)intercept.get();
            }
        }
        return null;
    }

    public static boolean canPvp(PlayerEntity attacker, PlayerEntity target) {
        return attacker.field_70170_p.func_73046_m().func_71219_W() && attacker != target && !attacker.func_184191_r((Entity)target);
    }

    public static Direction getDirectionFacing(Entity entity, boolean lateralOnly) {
        if (!lateralOnly) {
            if (entity.field_70125_A < -50.0f) {
                return Direction.DOWN;
            }
            if (entity.field_70125_A > 50.0f) {
                return Direction.UP;
            }
        }
        int vec = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (++vec % 4) {
            case 0: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static class Predicates {
        public static final Predicate<LivingEntity> HOSTILE_MOB = entity -> entity instanceof IMob;
    }
}

