/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class ItemUtil {
    public static IItemTier customItemTier(final int durability, final float efficiency, final float attackDamage, final int harvestLevel, final int enchantability, @Nullable Supplier<Item> repairMaterial) {
        final Supplier<Item> repairItem = repairMaterial;
        return new IItemTier(){

            public int func_200926_a() {
                return durability;
            }

            public float func_200928_b() {
                return efficiency;
            }

            public float func_200929_c() {
                return attackDamage;
            }

            public int func_200925_d() {
                return harvestLevel;
            }

            public int func_200927_e() {
                return enchantability;
            }

            public Ingredient func_200924_f() {
                return repairItem == null ? Ingredient.field_193370_a : Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)repairItem.get()});
            }
        };
    }

    public static IArmorMaterial customArmourMaterial(final String name, final int durabilityBase, final int[] protectionValues, final int enchantability, final SoundEvent equipSound, final float toughness) {
        return new IArmorMaterial(){

            public int func_200896_a(EquipmentSlotType slot) {
                switch (slot) {
                    case HEAD: {
                        return 11 * durabilityBase;
                    }
                    case CHEST: {
                        return 16 * durabilityBase;
                    }
                    case LEGS: {
                        return 15 * durabilityBase;
                    }
                    case FEET: {
                        return 13 * durabilityBase;
                    }
                }
                return 0;
            }

            public int func_200902_b(EquipmentSlotType slot) {
                return protectionValues[slot.func_188454_b()];
            }

            public int func_200900_a() {
                return enchantability;
            }

            public SoundEvent func_200899_b() {
                return equipSound;
            }

            public Ingredient func_200898_c() {
                return Ingredient.field_193370_a;
            }

            public String func_200897_d() {
                return name;
            }

            public float func_200901_e() {
                return toughness;
            }
        };
    }

    public static boolean hasEnchantment(Enchantment enchant, ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)stack) > 0;
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, Hand hand) {
        ItemUtil.damageItem(stack, entity, 1, PlayerUtil.handToEquipmentSlotType(hand));
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, int amount, EquipmentSlotType slot) {
        stack.func_222118_a(amount, entity, user -> user.func_213361_c(slot));
    }

    public static void givePlayerMultipleItems(PlayerEntity pl, ItemStack ... stacks) {
        ItemUtil.givePlayerMultipleItems(pl, Arrays.asList(stacks));
    }

    public static void givePlayerMultipleItems(PlayerEntity pl, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (pl.field_71071_by.func_70441_a(stack)) continue;
            pl.func_70099_a(stack, 0.5f);
        }
        pl.field_71069_bz.func_75142_b();
    }

    public static void givePlayerItemOrDrop(PlayerEntity player, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 0.5f);
        }
        player.field_71069_bz.func_75142_b();
    }

    public static boolean isHoldingItem(LivingEntity entity, Item item) {
        return entity.func_184614_ca().func_77973_b() == item || entity.func_184592_cb().func_77973_b() == item;
    }

    public static boolean hasLevelForItem(Item item, PlayerDataManager plData) {
        if (item == null) {
            return false;
        }
        if (!PlayerUtil.shouldPlayerBeAffected((PlayerEntity)plData.player()) || !(item instanceof SkillItem)) {
            return true;
        }
        SkillItem skillItem = (SkillItem)item;
        return skillItem.getLevelReq() <= plData.stats().getLevel(skillItem.getSkill());
    }

    public static ItemStack removeEnchantment(ItemStack stack, Enchantment ench) {
        ItemStack newStack = stack.func_77946_l();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)newStack);
        if (enchants.containsKey(ench)) {
            enchants.remove(ench);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)newStack);
        }
        return newStack;
    }

    public static void setAttribute(Multimap<String, AttributeModifier> map, IAttribute att, UUID id, double value) {
        Collection modifiers = map.get((Object)att.func_111108_a());
        Optional<AttributeModifier> mod = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (mod.isPresent()) {
            AttributeModifier existingMod = mod.get();
            modifiers.remove(existingMod);
            modifiers.add(new AttributeModifier(existingMod.func_111167_a(), existingMod.func_111166_b(), value, existingMod.func_220375_c()));
        }
    }

    public static void clearInventoryOfItems(PlayerEntity player, ItemStack ... stacks) {
        if (player.func_184812_l_()) {
            return;
        }
        ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!checkStack.func_190926_b()) {
            for (Object stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack, stack)) continue;
                checkStack.func_190920_e(0);
                break;
            }
        }
        if (!(checkStack = player.func_184586_b(Hand.OFF_HAND)).func_190926_b()) {
            for (Object stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack, stack)) continue;
                checkStack.func_190920_e(0);
                break;
            }
        }
        block2: for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
            if (checkStack2.func_190926_b()) continue;
            ItemStack[] itemStackArray = stacks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack stack = itemStackArray[i];
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack2, stack)) continue;
                checkStack2.func_190920_e(0);
                continue block2;
            }
        }
        block4: for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
            if (checkStack2.func_190926_b()) continue;
            for (ItemStack stack : stacks) {
                if (!ItemUtil.areStacksFunctionallyEqual(checkStack2, stack)) continue;
                checkStack2.func_190920_e(0);
                continue block4;
            }
        }
    }

    public static boolean findItemByTag(PlayerEntity player, Tag<Item> tag, boolean consumeItem, int amount) {
        if (amount <= 0 || player.func_184812_l_()) {
            return true;
        }
        if (amount == 1) {
            ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
            if (checkStack.func_77973_b().func_206844_a(tag) && !checkStack.func_190926_b()) {
                if (consumeItem) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            checkStack = player.func_184586_b(Hand.OFF_HAND);
            if (checkStack.func_77973_b().func_206844_a(tag) && !checkStack.func_190926_b()) {
                if (consumeItem) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !checkStack2.func_77973_b().func_206844_a(tag)) continue;
                if (consumeItem) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !checkStack2.func_77973_b().func_206844_a(tag)) continue;
                if (consumeItem) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            return false;
        }
        ArrayList<ItemStack> matchedStacks = new ArrayList<ItemStack>();
        int foundCount = 0;
        ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
        if (checkStack.func_77973_b().func_206844_a(tag) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount && (checkStack = player.func_184586_b(Hand.OFF_HAND)).func_77973_b().func_206844_a(tag) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !checkStack2.func_77973_b().func_206844_a(tag)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !checkStack2.func_77973_b().func_206844_a(tag)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return false;
        }
        if (!consumeItem) {
            return true;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.func_190916_E(), Math.min(amount, foundCount));
            matchedStack.func_190918_g(consumeAmount);
            foundCount -= consumeAmount;
        }
        return true;
    }

    public static boolean findInventoryItem(PlayerEntity player, ItemStack stack, boolean consumeItem, int amount) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (amount <= 0 || player.func_184812_l_()) {
            return true;
        }
        if (amount == 1) {
            ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
                if (consumeItem) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            checkStack = player.func_184586_b(Hand.OFF_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
                if (consumeItem) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            return false;
        }
        ArrayList<ItemStack> matchedStacks = new ArrayList<ItemStack>();
        int foundCount = 0;
        ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount && ItemUtil.areStacksFunctionallyEqual(checkStack = player.func_184586_b(Hand.OFF_HAND), stack) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return false;
        }
        if (!consumeItem) {
            return true;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.func_190916_E(), Math.min(amount, foundCount));
            matchedStack.func_190918_g(consumeAmount);
            foundCount -= consumeAmount;
        }
        return true;
    }

    public static boolean findAndConsumeRunes(HashMap<RuneItem, Integer> runeMap, ServerPlayerEntity player, boolean allowBuffs, @Nonnull ItemStack heldItem) {
        int amount;
        RuneItem type;
        if (player.func_184812_l_()) {
            return true;
        }
        AdventArmour.Type armour = PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet();
        int archmage = allowBuffs ? EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.ARCHMAGE.get()), (ItemStack)heldItem) : 0;
        boolean nightmareArmour = allowBuffs && armour == AdventArmour.Type.NIGHTMARE;
        boolean greed = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)heldItem) > 0;
        HashMap<RuneItem, Integer> requiredRunes = new HashMap<RuneItem, Integer>();
        for (Map.Entry<RuneItem, Integer> runeEntry : runeMap.entrySet()) {
            if (!allowBuffs || archmage == 0 && !nightmareArmour && !greed) {
                requiredRunes.putAll(runeMap);
                break;
            }
            int amount2 = runeEntry.getValue();
            if (greed) {
                amount2 += 2;
            }
            if (archmage > 0) {
                amount2 -= archmage;
            }
            if (nightmareArmour) {
                --amount2;
            }
            if (amount2 <= 0) {
                amount2 = 1;
            }
            requiredRunes.put(runeEntry.getKey(), amount2);
        }
        if (requiredRunes.isEmpty()) {
            return true;
        }
        HashSet<Integer> runeSlots = new HashSet<Integer>();
        HashMap<RuneItem, Integer> runeCounter = new HashMap<RuneItem, Integer>(requiredRunes);
        ItemStack mainHandStack = player.func_184586_b(Hand.OFF_HAND);
        ItemStack offHandStack = player.func_184586_b(Hand.MAIN_HAND);
        if (mainHandStack.func_77973_b() instanceof RuneItem && runeCounter.containsKey((Object)(type = (RuneItem)mainHandStack.func_77973_b()))) {
            amount = (Integer)runeCounter.get((Object)type);
            runeSlots.add(-1);
            if ((amount -= mainHandStack.func_190916_E()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove((Object)type);
            }
        }
        if (!runeCounter.isEmpty() && offHandStack.func_77973_b() instanceof RuneItem && runeCounter.containsKey((Object)(type = (RuneItem)offHandStack.func_77973_b()))) {
            amount = (Integer)runeCounter.get((Object)type);
            runeSlots.add(-2);
            if ((amount -= offHandStack.func_190916_E()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove((Object)type);
            }
        }
        if (!runeCounter.isEmpty()) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                RuneItem type2;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof RuneItem) || !runeCounter.containsKey((Object)(type2 = (RuneItem)stack.func_77973_b()))) continue;
                int amount3 = (Integer)runeCounter.get((Object)type2);
                runeSlots.add(i);
                if ((amount3 -= stack.func_190916_E()) > 0) {
                    runeCounter.put(type2, amount3);
                } else {
                    runeCounter.remove((Object)type2);
                }
                if (runeCounter.isEmpty()) break;
            }
        }
        if (runeCounter.isEmpty()) {
            int remaining;
            if (runeSlots.contains(-1)) {
                ItemStack rune = player.func_184586_b(Hand.MAIN_HAND);
                RuneItem type3 = (RuneItem)rune.func_77973_b();
                int amount4 = (Integer)requiredRunes.get((Object)type3);
                remaining = amount4 - rune.func_190916_E();
                rune.func_190918_g(amount4);
                if (remaining <= 0) {
                    requiredRunes.remove((Object)type3);
                } else {
                    requiredRunes.put(type3, remaining);
                }
                runeSlots.remove(-1);
            }
            if (runeSlots.contains(-2)) {
                ItemStack rune = player.func_184586_b(Hand.OFF_HAND);
                RuneItem type4 = (RuneItem)rune.func_77973_b();
                int amount5 = (Integer)requiredRunes.get((Object)type4);
                remaining = amount5 - rune.func_190916_E();
                rune.func_190918_g(amount5);
                if (remaining <= 0) {
                    requiredRunes.remove((Object)type4);
                } else {
                    requiredRunes.put(type4, remaining);
                }
                runeSlots.remove(-2);
            }
            Iterator iterator = runeSlots.iterator();
            while (iterator.hasNext()) {
                int slotId = (Integer)iterator.next();
                ItemStack rune = player.field_71071_by.func_70301_a(slotId);
                RuneItem type5 = (RuneItem)rune.func_77973_b();
                int amount6 = (Integer)requiredRunes.get((Object)type5);
                int remaining2 = amount6 - rune.func_190916_E();
                rune.func_190918_g(amount6);
                if (remaining2 <= 0) {
                    requiredRunes.remove((Object)type5);
                } else {
                    requiredRunes.put(type5, remaining2);
                }
                if (!requiredRunes.isEmpty()) continue;
                break;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack getStackFromHotbar(PlayerEntity player, Item item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public static ItemStack getStackFromInventory(PlayerEntity player, Item item) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        ItemStack checkStack = player.func_184586_b(Hand.MAIN_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
            return checkStack;
        }
        checkStack = player.func_184586_b(Hand.OFF_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
            return checkStack;
        }
        for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
            if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
            return checkStack2;
        }
        for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
            if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
            return checkStack2;
        }
        return null;
    }

    public static boolean areStacksFunctionallyEqual(ItemStack a, ItemStack b) {
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77984_f() ^ b.func_77984_f()) {
            return false;
        }
        if (!a.func_77984_f() && a.func_77952_i() != b.func_77952_i()) {
            return false;
        }
        return !a.func_77942_o() ? !b.func_77942_o() : b.func_77942_o() && a.func_77978_p().equals((Object)b.func_77978_p());
    }
}

