/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;

public abstract class LootUtil {
    public static LootTable getTable(ServerWorld world, ResourceLocation table) {
        return world.func_73046_m().func_200249_aQ().func_186521_a(table);
    }

    @Nonnull
    public static List<ItemStack> generateLoot(ServerWorld world, ResourceLocation table, LootContext context) {
        LootTable lootTable = LootUtil.getTable(world, table);
        if (lootTable == LootTable.field_186464_a) {
            return Lists.newArrayList();
        }
        return lootTable.func_216113_a(context);
    }

    public static LootContext getGiftContext(ServerWorld world, BlockPos position, Entity targetEntity) {
        return LootUtil.getGiftContext(world, position, 0.0f, targetEntity);
    }

    public static LootContext getGiftContext(ServerWorld world, BlockPos position, float luck, Entity targetEntity) {
        return new LootContext.Builder(world).func_216023_a(world.func_201674_k()).func_216015_a(LootParameters.field_216281_a, (Object)targetEntity).func_216015_a(LootParameters.field_216286_f, (Object)position).func_186469_a(luck).func_216022_a(LootParameterSets.field_216264_e);
    }
}

