/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;

public abstract class NBTUtil {

    public static class NBTBuilder<T extends INBT> {
        private final T tag;
        private HashMap<String, NBTBuilder<?>> childTags;

        public NBTBuilder(T nbtBase) {
            this.tag = nbtBase;
        }

        public NBTBuilder<T> putTag(@Nullable String key, NBTBuilder<?> tag) {
            if (this.childTags == null) {
                this.childTags = new HashMap();
            }
            this.childTags.put(key, tag);
            return this;
        }

        public NBTBuilder<T> putString(@Nullable String key, String value) {
            if (this.tag.func_225647_b_() == CompoundNBT.field_229675_a_ && key != null) {
                ((CompoundNBT)this.tag).func_218657_a(key, (INBT)StringNBT.func_229705_a_((String)value));
            } else if (this.tag.func_225647_b_() == ListNBT.field_229694_a_) {
                ((ListNBT)this.tag).add((Object)StringNBT.func_229705_a_((String)value));
            }
            return this;
        }

        public NBTBuilder<T> putInteger(@Nullable String key, int value) {
            if (this.tag.func_225647_b_() == CompoundNBT.field_229675_a_ && key != null) {
                ((CompoundNBT)this.tag).func_218657_a(key, (INBT)IntNBT.func_229692_a_((int)value));
            } else if (this.tag.func_225647_b_() == ListNBT.field_229694_a_) {
                ((ListNBT)this.tag).add((Object)IntNBT.func_229692_a_((int)value));
            }
            return this;
        }

        public NBTBuilder<T> putFloat(@Nullable String key, float value) {
            if (this.tag.func_225647_b_() == CompoundNBT.field_229675_a_ && key != null) {
                ((CompoundNBT)this.tag).func_218657_a(key, (INBT)FloatNBT.func_229689_a_((float)value));
            } else if (this.tag.func_225647_b_() == ListNBT.field_229694_a_) {
                ((ListNBT)this.tag).add((Object)FloatNBT.func_229689_a_((float)value));
            }
            return this;
        }

        public NBTBuilder<T> putLong(@Nullable String key, long value) {
            if (this.tag.func_225647_b_() == CompoundNBT.field_229675_a_ && key != null) {
                ((CompoundNBT)this.tag).func_218657_a(key, (INBT)LongNBT.func_229698_a_((long)value));
            } else if (this.tag.func_225647_b_() == ListNBT.field_229694_a_) {
                ((ListNBT)this.tag).add((Object)LongNBT.func_229698_a_((long)value));
            }
            return this;
        }

        public T build() {
            if (this.childTags != null && !this.childTags.isEmpty()) {
                if (this.tag.func_225647_b_() == CompoundNBT.field_229675_a_) {
                    Map.Entry firstEntry = (Map.Entry)this.childTags.entrySet().stream().findFirst().get();
                    ((CompoundNBT)this.tag).func_218657_a((String)firstEntry.getKey(), ((NBTBuilder)firstEntry.getValue()).build());
                } else if (this.tag.func_225647_b_() == ListNBT.field_229694_a_) {
                    for (Map.Entry<String, NBTBuilder<?>> childEntry : this.childTags.entrySet()) {
                        ((ListNBT)this.tag).add(childEntry.getValue().build());
                    }
                }
            }
            return this.tag;
        }
    }
}

