/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.text.DecimalFormat;

public abstract class NumberUtil {
    public static int RGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int RGB(float red, float green, float blue) {
        return (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static int alpha(int colour, int alpha) {
        return alpha << 24 | colour;
    }

    public static String floorAndAppendSuffix(float value, boolean strictDigitCount) {
        String suffix = "";
        if (value >= 10000.0f) {
            if (value < 1000000.0f) {
                suffix = "k";
                value /= 1000.0f;
            } else if (value < 1.0E9f) {
                suffix = "m";
                value /= 1000000.0f;
            } else {
                suffix = "b";
                value /= 1.0E9f;
            }
        }
        if (strictDigitCount && value >= 10.0f) {
            value = (int)value;
        }
        return new DecimalFormat(strictDigitCount ? "#.#" : "#.##").format(value) + suffix;
    }

    public static double average(double ... values) {
        double sum = 0.0;
        for (double d : values) {
            sum += d;
        }
        return sum / (double)values.length;
    }

    public static String roundToNthDecimalPlace(float value, int decimals) {
        float val = (float)Math.round(value * (float)Math.pow(10.0, decimals)) / (float)Math.pow(10.0, decimals);
        if ((float)((int)val) == val) {
            return String.valueOf((int)val);
        }
        return String.valueOf(val);
    }
}

