/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class PotionUtil {
    public static final int MAX_POTION_DURATION = 9999999;
    public static final int AMBIENT_POTION_DURATION = -1;

    public static boolean amplifyEffect(EffectInstance effect, int amplification) {
        return effect.func_199308_a(new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + amplification, effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
    }

    public static class PotionBuilder {
        Item potionItem;
        String displayName = null;
        boolean translatable = false;
        ArrayList<EffectInstance> effects = null;
        Integer colour = null;
        boolean dynamicColour = false;

        public PotionBuilder(Item potionItem) {
            this.potionItem = potionItem;
        }

        public PotionBuilder withName(String name) {
            this.displayName = name;
            return this;
        }

        public PotionBuilder withTranslationKey(String nameLangKey) {
            this.displayName = nameLangKey;
            this.translatable = true;
            return this;
        }

        public PotionBuilder addEffect(EffectInstance effect) {
            if (this.effects == null) {
                this.effects = new ArrayList(1);
            }
            this.effects.add(effect);
            return this;
        }

        public PotionBuilder withColour(int colour) {
            this.colour = Integer.parseInt(String.valueOf(colour), 16);
            return this;
        }

        public PotionBuilder enableDynamicColour() {
            this.dynamicColour = true;
            return this;
        }

        public ItemStack build() {
            ItemStack stack = new ItemStack((IItemProvider)this.potionItem);
            CompoundNBT nbt = stack.func_196082_o();
            CompoundNBT displayTag = stack.func_190925_c("display");
            if (this.displayName != null) {
                stack.func_200302_a((ITextComponent)(this.translatable ? new TranslationTextComponent(this.displayName, new Object[0]) : new StringTextComponent(this.displayName)));
            }
            if (this.dynamicColour && this.effects != null) {
                this.colour = PotionUtils.func_185181_a(this.effects);
            }
            if (this.colour != null) {
                displayTag.func_74778_a("CustomPotionColor", Integer.toHexString(this.colour));
            }
            if (this.effects != null && !this.effects.isEmpty()) {
                PotionUtils.func_185184_a((ItemStack)stack, this.effects);
            }
            if (!displayTag.isEmpty()) {
                nbt.func_218657_a("display", (INBT)displayTag);
            }
            return stack;
        }
    }

    public static class EffectBuilder {
        private final Effect effect;
        private final int duration;
        private int level = 1;
        private boolean ambient = false;
        private boolean showParticles = true;
        private boolean showIcon = true;

        public EffectBuilder(Effect effect) {
            this(effect, -1);
        }

        public EffectBuilder(Effect effect, int duration) {
            this.effect = effect;
            this.duration = duration;
        }

        public EffectBuilder isAmbient() {
            this.ambient = true;
            return this;
        }

        public EffectBuilder level(int level) {
            this.level = level;
            return this;
        }

        public EffectBuilder hideParticles() {
            this.showParticles = false;
            return this;
        }

        public EffectBuilder hideEffectIcon() {
            this.showIcon = false;
            return this;
        }

        public Effect getEffect() {
            return this.effect;
        }

        public EffectInstance build() {
            return new EffectInstance(this.effect, this.duration, this.level - 1, this.ambient, this.showParticles, this.showIcon);
        }
    }
}

