/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public abstract class RandomUtil {
    public static final EasyRandom RANDOM = new EasyRandom(new Random());

    public static boolean fiftyFifty() {
        return RANDOM.fiftyFifty();
    }

    public static boolean oneInNChance(int n) {
        return RANDOM.oneInNChance(n);
    }

    public static boolean percentChance(double percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static int randomNumberUpTo(int upperBound) {
        return RANDOM.randomNumberUpTo(upperBound);
    }

    public static float randomValueUpTo(float upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomValueUpTo(double upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomGaussianValue() {
        return RANDOM.randomGaussianValue();
    }

    public static double randomScaledGaussianValue(double scale) {
        return RANDOM.randomScaledGaussianValue(scale);
    }

    public static int randomNumberBetween(int min, int max) {
        return RANDOM.randomNumberBetween(min, max);
    }

    public static double randomValueBetween(double min, double max) {
        return RANDOM.randomValueBetween(min, max);
    }

    public static <T> T getRandomSelection(T ... options) {
        return RANDOM.getRandomSelection(options);
    }

    public static <T> T getRandomSelection(@Nonnull List<T> options) {
        return RANDOM.getRandomSelection(options);
    }

    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius);
    }

    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, World world) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world);
    }

    public static final class EasyRandom {
        private final Random RANDOM;

        public EasyRandom(@Nonnull Random rand) {
            this.RANDOM = rand;
        }

        public Random source() {
            return this.RANDOM;
        }

        public boolean fiftyFifty() {
            return this.RANDOM.nextBoolean();
        }

        public boolean oneInNChance(int n) {
            if (n <= 0) {
                return false;
            }
            return this.RANDOM.nextFloat() < 1.0f / (float)n;
        }

        public boolean percentChance(double percentChance) {
            if (percentChance <= 0.0) {
                return false;
            }
            if (percentChance >= 1.0) {
                return true;
            }
            return this.RANDOM.nextDouble() < percentChance;
        }

        public int randomNumberUpTo(int upperBound) {
            return this.RANDOM.nextInt(upperBound);
        }

        public float randomValueUpTo(float upperBound) {
            return this.RANDOM.nextFloat() * upperBound;
        }

        public double randomValueUpTo(double upperBound) {
            return this.RANDOM.nextDouble() * upperBound;
        }

        public double randomGaussianValue() {
            return this.RANDOM.nextGaussian();
        }

        public double randomScaledGaussianValue(double scale) {
            return this.RANDOM.nextGaussian() * scale;
        }

        public int randomNumberBetween(int min, int max) {
            return min + this.RANDOM.nextInt(max - min);
        }

        public double randomValueBetween(double min, double max) {
            return min + this.RANDOM.nextDouble() * (max - min);
        }

        public <T> T getRandomSelection(T ... options) {
            return options[this.RANDOM.nextInt(options.length)];
        }

        public <T> T getRandomSelection(@Nonnull List<T> options) {
            return options.get(this.RANDOM.nextInt(options.size()));
        }

        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, false, null);
        }

        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, World world) {
            BlockPos.Mutable mutablePos = new BlockPos.Mutable(centerPos);
            int newX = (int)Math.floor((float)mutablePos.func_177958_n() + this.RANDOM.nextFloat() * (float)xRadius * 2.0f - (float)xRadius);
            int newY = (int)Math.floor((float)mutablePos.func_177956_o() + this.RANDOM.nextFloat() * (float)yRadius * 2.0f - (float)yRadius);
            int newZ = (int)Math.floor((float)mutablePos.func_177952_p() + this.RANDOM.nextFloat() * (float)zRadius * 2.0f - (float)zRadius);
            mutablePos.func_181079_c(newX, newY, newZ);
            if (safeSurfacePlacement && world != null) {
                mutablePos.func_189533_g((Vec3i)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos));
            }
            return mutablePos.func_185334_h();
        }
    }
}

