/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class RenderUtil {
    public static void renderTexture(int x, int y, float u, float v, float width, float height) {
        RenderUtil.renderCustomSizedTexture(x, y, u, v, (int)width, (int)height, width, height);
    }

    public static void renderCustomSizedTexture(int x, int y, float u, float v, int uWidth, int vHeight, float textureWidth, float textureHeight) {
        RenderUtil.renderScaledCustomSizedTexture(x, y, u, v, uWidth, vHeight, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void renderScaledCustomSizedTexture(double x, double y, float u, float v, float uWidth, float vHeight, double renderWidth, double renderHeight, float textureWidth, float textureHeight) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        float widthRatio = 1.0f / textureWidth;
        float heightRatio = 1.0f / textureHeight;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(x, y + renderHeight, 0.0).func_225583_a_(u * widthRatio, (v + vHeight) * heightRatio).func_181675_d();
        buffer.func_225582_a_(x + renderWidth, y + renderHeight, 0.0).func_225583_a_((u + uWidth) * widthRatio, (v + vHeight) * heightRatio).func_181675_d();
        buffer.func_225582_a_(x + renderWidth, y, 0.0).func_225583_a_((u + uWidth) * widthRatio, v * heightRatio).func_181675_d();
        buffer.func_225582_a_(x, y, 0.0).func_225583_a_(u * widthRatio, v * heightRatio).func_181675_d();
        buffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
    }

    public static void drawVerticalGradient(int x, int y, int z, int width, int height, int topColour, int bottomColour) {
        float alphaTop = (float)(topColour >> 24 & 0xFF) / 255.0f;
        float redTop = (float)(topColour >> 16 & 0xFF) / 255.0f;
        float greenTop = (float)(topColour >> 8 & 0xFF) / 255.0f;
        float blueTop = (float)(topColour & 0xFF) / 255.0f;
        float alphaBottom = (float)(bottomColour >> 24 & 0xFF) / 255.0f;
        float redBottom = (float)(bottomColour >> 16 & 0xFF) / 255.0f;
        float greenBottom = (float)(bottomColour >> 8 & 0xFF) / 255.0f;
        float blueBottom = (float)(bottomColour & 0xFF) / 255.0f;
        RenderSystem.pushTextureAttributes();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, (double)z).func_227885_a_(redTop, greenTop, blueTop, alphaTop).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)z).func_227885_a_(redTop, greenTop, blueTop, alphaTop).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), (double)z).func_227885_a_(redBottom, greenBottom, blueBottom, alphaBottom).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_227885_a_(redBottom, greenBottom, blueBottom, alphaBottom).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.popAttributes();
    }

    public static void drawColouredBox(int x, int y, int z, int width, int height, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix = TransformationMatrix.func_227983_a_().func_227988_c_();
        RenderSystem.pushTextureAttributes();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y + (float)height, (float)z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x + (float)width, (float)y + (float)height, (float)z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x + (float)width, (float)y, (float)z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, (float)z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popAttributes();
    }

    public static void drawCenteredScaledString(FontRenderer fontRenderer, String msg, int x, int y, float scale, int colour, StringRenderType renderType) {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        float realX = ((float)x - (float)fontRenderer.func_78256_a(msg) * scale / 2.0f) / scale;
        float realY = (float)y / scale;
        if (renderType == StringRenderType.OUTLINED) {
            fontRenderer.func_211126_b(msg, realX, realY + 1.0f / scale, 0);
            fontRenderer.func_211126_b(msg, realX, realY - 1.0f / scale, 0);
            fontRenderer.func_211126_b(msg, realX + 1.0f / scale, realY, 0);
            fontRenderer.func_211126_b(msg, realX - 1.0f / scale, realY, 0);
        }
        if (renderType == StringRenderType.DROP_SHADOW) {
            fontRenderer.func_175063_a(msg, realX, realY, colour);
        } else {
            fontRenderer.func_211126_b(msg, realX, realY, colour);
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.popMatrix();
    }

    public static void drawScaledString(FontRenderer fontRenderer, String msg, int x, int y, float scale, int colour, StringRenderType renderType) {
        float realX = (float)x / scale;
        float realY = (float)y / scale;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        if (renderType == StringRenderType.OUTLINED) {
            fontRenderer.func_211126_b(msg, realX, realY + 1.0f / scale, 0);
            fontRenderer.func_211126_b(msg, realX, realY - 1.0f / scale, 0);
            fontRenderer.func_211126_b(msg, realX + 1.0f / scale, realY, 0);
            fontRenderer.func_211126_b(msg, realX - 1.0f / scale, realY, 0);
        }
        if (renderType == StringRenderType.DROP_SHADOW) {
            fontRenderer.func_175063_a(msg, realX, realY, colour);
        } else {
            fontRenderer.func_211126_b(msg, realX, realY, colour);
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.popMatrix();
    }

    public static void drawOutlinedText(FontRenderer fontRenderer, String msg, int x, int y, int colour, float currentScale) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        fontRenderer.func_211126_b(msg, (float)x, (float)y + 1.0f / currentScale, 0);
        fontRenderer.func_211126_b(msg, (float)x, (float)y - 1.0f / currentScale, 0);
        fontRenderer.func_211126_b(msg, (float)x + 1.0f / currentScale, (float)y, 0);
        fontRenderer.func_211126_b(msg, (float)x - 1.0f / currentScale, (float)y, 0);
        fontRenderer.func_211126_b(msg, (float)x, (float)y, colour);
        RenderSystem.enableAlphaTest();
    }

    public static enum StringRenderType {
        NORMAL,
        DROP_SHADOW,
        OUTLINED;

    }
}

