/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.library.misc.AoAHalos;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.library.scheduling.async.UpdateHalosMapTask;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public abstract class WebUtil {
    private static Boolean isUpdateAvailable = null;
    private static String latestVersion = "3.4.9";

    public static void doHTTPTasks() {
        Logging.logMessage(Level.DEBUG, "Starting web tasks");
        VersionChecker.CheckResult updateCheckResult = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("aoa3").getMods().get(0)));
        if (updateCheckResult.status == VersionChecker.Status.OUTDATED) {
            isUpdateAvailable = true;
            latestVersion = updateCheckResult.target.toString();
        } else {
            isUpdateAvailable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<UUID, AoAHalos.PlayerHaloContainer> fillHalosMap(HashMap<UUID, AoAHalos.PlayerHaloContainer> halosMap) {
        Logging.logMessage(Level.DEBUG, "Updating player halos map");
        BufferedReader fileReader = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://gist.githubusercontent.com/Tslat/2c2eb98dceeff18f05ed068982fb71a7/raw/").openConnection();
            connection.setConnectTimeout(1000);
            connection.connect();
            if (200 != connection.getResponseCode()) {
                Logging.logMessage(Level.DEBUG, "Failed connection to cloud based halos map, response code " + connection.getResponseMessage());
                HashMap<UUID, AoAHalos.PlayerHaloContainer> hashMap = halosMap;
                IOUtils.closeQuietly((Reader)fileReader);
                return hashMap;
            }
            fileReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            if (halosMap != null) {
                String line;
                while ((line = fileReader.readLine()) != null) {
                    UUID uuid;
                    String[] lineSplit;
                    if (line.startsWith(" <!DOCTYPE") || (lineSplit = line.split("\\|")).length <= 2) continue;
                    HashSet<AoAHalos.Type> halosSet = new HashSet<AoAHalos.Type>(lineSplit.length - 1);
                    try {
                        uuid = UUID.fromString(lineSplit[1]);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!((Boolean)AoAConfig.CLIENT.doVerboseDebugging.get()).booleanValue()) continue;
                        Logging.logMessage(Level.WARN, "Invalid UUID format from web: " + lineSplit[1]);
                        continue;
                    }
                    for (int i = 2; i < lineSplit.length; ++i) {
                        try {
                            halosSet.add(AoAHalos.Type.valueOf(lineSplit[i]));
                            continue;
                        }
                        catch (IllegalArgumentException ex) {
                            if (!((Boolean)AoAConfig.CLIENT.doVerboseDebugging.get()).booleanValue()) continue;
                            Logging.logMessage(Level.WARN, "Invalid halo type from web: " + lineSplit[i]);
                        }
                    }
                    halosMap.put(uuid, new AoAHalos.PlayerHaloContainer(halosSet));
                    Logging.logMessage(Level.DEBUG, "Found player halo for " + uuid.toString());
                }
                HashSet<AoAHalos.Type> haloSet = new HashSet<AoAHalos.Type>(1);
                haloSet.add(AoAHalos.Type.Tslat);
                halosMap.put(UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4"), new AoAHalos.PlayerHaloContainer(haloSet));
            }
            connection.disconnect();
            IOUtils.closeQuietly((Reader)fileReader);
        }
        catch (Exception e) {
            Logging.logMessage(Level.WARN, "Error while performing HTTP Tasks, dropping.");
            if (((Boolean)AoAConfig.CLIENT.doVerboseDebugging.get()).booleanValue()) {
                e.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly(fileReader);
        }
        return halosMap;
    }

    public static void extraPlayerHalosFromWeb() {
        HashMap<UUID, AoAHalos.PlayerHaloContainer> newMap = AoAHalos.getHaloMapForPrefill();
        if (newMap != null) {
            WebUtil.fillHalosMap(newMap);
            AoAScheduler.scheduleAsyncTask(new UpdateHalosMapTask(), 60, TimeUnit.MINUTES);
        }
    }

    public static boolean isUpdateAvailable() {
        if (isUpdateAvailable == null) {
            WebUtil.doHTTPTasks();
        }
        return isUpdateAvailable;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

