/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.ArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class WorldUtil {
    public static boolean checkGameRule(World world, GameRules.RuleKey<GameRules.BooleanValue> gameRule) {
        return world.func_82736_K().func_223586_b(gameRule);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, BlockPos pos, float strength) {
        return WorldUtil.createExplosion(exploder, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), strength, WorldUtil.checkGameRule(world, AoAGameRules.DESTRUCTIVE_WEAPON_PHYSICS) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
    }

    public static Explosion createExplosion(@Nonnull Entity exploder, World world, float strength) {
        return WorldUtil.createExplosion(exploder, world, exploder.func_226277_ct_(), exploder.func_226278_cu_(), exploder.func_226281_cx_(), strength, WorldUtil.checkGameRule(world, AoAGameRules.STRONGER_MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, @Nonnull Entity explodingEntity, float strength) {
        boolean doGriefing;
        if (exploder instanceof PlayerEntity) {
            doGriefing = WorldUtil.checkGameRule(world, AoAGameRules.DESTRUCTIVE_WEAPON_PHYSICS);
        } else {
            doGriefing = exploder instanceof LivingEntity || explodingEntity instanceof LivingEntity ? WorldUtil.checkGameRule(world, AoAGameRules.STRONGER_MOB_GRIEFING) : WorldUtil.checkGameRule(world, AoAGameRules.DESTRUCTIVE_WEAPON_PHYSICS);
            if (exploder == null) {
                exploder = explodingEntity;
            }
        }
        return WorldUtil.createExplosion(exploder, world, explodingEntity.func_226277_ct_(), explodingEntity.func_226278_cu_(), explodingEntity.func_226281_cx_(), strength, doGriefing ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, WorldUtil.checkGameRule(world, AoAGameRules.DESTRUCTIVE_WEAPON_PHYSICS) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength, Explosion.Mode explosionType) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, explosionType, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength, Explosion.Mode explosionType, boolean fieryExplosion) {
        return world.func_217398_a(exploder, posX, posY, posZ, strength, fieryExplosion, explosionType);
    }

    public static int getLightLevel(World world, BlockPos position, boolean ignoreSkyLight, boolean ignoreBlockLight) {
        if (ignoreBlockLight && ignoreSkyLight) {
            ignoreBlockLight = false;
            ignoreSkyLight = false;
        }
        if (position.func_177956_o() > 255) {
            position = new BlockPos(position.func_177958_n(), 255, position.func_177952_p());
        } else if (position.func_177956_o() < 0) {
            position = new BlockPos(position.func_177958_n(), 0, position.func_177952_p());
        }
        if (ignoreSkyLight) {
            return world.func_226658_a_(LightType.BLOCK, position);
        }
        if (ignoreBlockLight) {
            return world.func_226658_a_(LightType.SKY, position) - world.func_175657_ab();
        }
        return world.func_226659_b_(position, 0);
    }

    public static void spawnLightning(ServerWorld world, @Nullable ServerPlayerEntity caster, double x, double y, double z, boolean destructive) {
        LightningBoltEntity lightning = new LightningBoltEntity((World)world, x, y, z, !destructive);
        if (caster != null) {
            lightning.func_204809_d(caster);
        }
        world.func_217468_a(lightning);
    }

    public static boolean harvestAdditionalBlock(World world, PlayerEntity pl, BlockPos breakPos, boolean damageTool) {
        BlockState blockState = world.func_180495_p(breakPos);
        Block block = blockState.func_177230_c();
        if (block.isAir(blockState, (IBlockReader)world, breakPos)) {
            return false;
        }
        if (!world.field_72995_K) {
            ServerPlayerEntity player = (ServerPlayerEntity)pl;
            GameType gameType = player.field_71134_c.func_73081_b();
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)player, (BlockPos)breakPos);
            if (exp == -1) {
                return false;
            }
            if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !pl.func_195070_dx()) {
                world.func_184138_a(breakPos, blockState, blockState, 3);
                return false;
            }
            if (pl.func_184614_ca().onBlockStartBreak(breakPos, pl) || pl.func_223729_a(world, breakPos, gameType)) {
                return false;
            }
            if (pl.func_184812_l_()) {
                if (blockState.removedByPlayer(world, breakPos, (PlayerEntity)player, false, world.func_204610_c(breakPos))) {
                    block.func_176206_d((IWorld)world, breakPos, blockState);
                }
            } else {
                boolean removed;
                ItemStack heldStack = pl.func_184614_ca();
                ItemStack clonedStack = heldStack.func_77946_l();
                boolean canHarvest = blockState.canHarvestBlock((IBlockReader)world, breakPos, pl);
                if (damageTool && blockState.func_185887_b((IBlockReader)world, breakPos) != 0.0f) {
                    heldStack.func_222118_a(1, (LivingEntity)pl, harvester -> harvester.func_213361_c(EquipmentSlotType.MAINHAND));
                }
                if (heldStack.func_190926_b() && !clonedStack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)pl, (ItemStack)clonedStack, (Hand)Hand.MAIN_HAND);
                }
                if (removed = blockState.removedByPlayer(world, breakPos, (PlayerEntity)player, canHarvest, world.func_204610_c(breakPos))) {
                    block.func_176206_d((IWorld)world, breakPos, blockState);
                    if (canHarvest) {
                        block.func_180657_a(world, pl, breakPos, blockState, world.func_175625_s(breakPos), clonedStack);
                    }
                    if (exp > 0) {
                        blockState.func_177230_c().func_180637_b(world, breakPos, exp);
                    }
                }
            }
            return true;
        }
        return true;
    }

    public static float getAmbientTemperature(World world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        float temp = biome.func_225486_c(pos);
        if (world.func_226660_f_(pos)) {
            temp = world.func_72935_r() ? (temp *= 1.35f) : (temp /= 1.35f);
            if (world.func_72896_J()) {
                if (biome.func_201851_b() == Biome.RainType.SNOW) {
                    temp /= 1.5f;
                } else if (biome.func_201851_b() == Biome.RainType.RAIN) {
                    temp /= 1.25f;
                }
            }
        }
        return temp;
    }

    @Nonnull
    public static ArrayList<PlayerEntity> getAllPlayersInRegion(World world, AxisAlignedBB region) {
        ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>();
        for (PlayerEntity player : world.func_217369_A()) {
            if (!region.func_72318_a(player.func_213303_ch())) continue;
            players.add(player);
        }
        return players;
    }

    public static int getTrueWorldHeight(World world, int x, int z) {
        boolean match1 = false;
        boolean match2 = false;
        try {
            int height;
            if (world.func_201675_m().func_186058_p() == AoADimensions.DEEPLANDS.type()) {
                height = 121;
            } else if (world.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
                height = 128;
            } else if (world.func_201675_m().func_186058_p() == AoADimensions.CRYSTEVIA.type()) {
                height = 127;
            } else {
                return world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
            }
            if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
                return 0;
            }
            for (int i = height; i > 0; --i) {
                if (world.func_180495_p(new BlockPos(x, i, z)).func_177230_c() == Blocks.field_150350_a) {
                    if (match1) {
                        if (match2) continue;
                        match2 = true;
                        continue;
                    }
                    match1 = true;
                    continue;
                }
                if (match1 && match2) {
                    return i;
                }
                match1 = false;
                match2 = false;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    public static void toAir(World world, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static boolean canModifyBlock(IWorld world, BlockPos pos, @Nullable Entity entity) {
        DimensionType dimType = world.func_201675_m().func_186058_p();
        PlayerEntity relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(entity);
        if (!(dimType != AoADimensions.IMMORTALLIS.type() && dimType != AoADimensions.ANCIENT_CAVERN.type() || relevantPlayer != null && relevantPlayer.func_184812_l_())) {
            return false;
        }
        return relevantPlayer == null || world.func_201672_e().canMineBlockBody(relevantPlayer, pos);
    }

    public static void operateOnMultipleBlocksInRange(World world, BlockPos center, int radius, Predicate<BlockState> test, Consumer<BlockPos> operation) {
        for (int x = center.func_177958_n() - radius; x < center.func_177958_n() + radius; ++x) {
            for (int y = center.func_177956_o() - radius; y < center.func_177956_o() + radius; ++y) {
                for (int z = center.func_177952_p() - radius; z < center.func_177952_p() + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!test.test(world.func_180495_p(pos))) continue;
                    operation.accept(pos);
                }
            }
        }
    }

    public static ArrayList<BlockPos> getBlocksWithinAABB(World world, AxisAlignedBB aabb, @Nullable BiPredicate<BlockState, BlockPos.Mutable> predicate) {
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        ArrayList<BlockPos> matches = new ArrayList<BlockPos>();
        int x = (int)Math.floor(aabb.field_72340_a);
        while ((double)x <= Math.ceil(aabb.field_72336_d)) {
            int y = (int)Math.floor(aabb.field_72338_b);
            while ((double)y <= Math.ceil(aabb.field_72337_e)) {
                int z = (int)Math.floor(aabb.field_72339_c);
                while ((double)z <= Math.ceil(aabb.field_72334_f)) {
                    checkPos.func_181079_c(x, y, z);
                    if (predicate == null || predicate.test(world.func_180495_p((BlockPos)checkPos), checkPos)) {
                        matches.add(checkPos.func_185334_h());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return matches;
    }
}

