/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util.player;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.capabilities.adventplayer.AdventPlayerCapability;
import net.tslat.aoa3.capabilities.adventplayer.AdventPlayerCapabilityHandles;
import net.tslat.aoa3.capabilities.adventplayer.AdventPlayerCapabilityProvider;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;

public class PlayerUtil {
    @Nonnull
    public static PlayerDataManager getAdventPlayer(@Nonnull ServerPlayerEntity player) {
        AdventPlayerCapabilityHandles cap = (AdventPlayerCapabilityHandles)player.getCapability(AdventPlayerCapabilityProvider.INSTANCE, null).orElse((Object)new AdventPlayerCapability(player));
        return cap.getPlayerData();
    }

    public static boolean doesPlayerHaveLevel(ServerPlayerEntity player, Skills skill, int level) {
        return (Boolean)AoAConfig.COMMON.skillsEnabled.get() == false || PlayerUtil.getAdventPlayer(player).stats().getLevel(skill) >= level;
    }

    public static void addTributeToPlayer(ServerPlayerEntity player, Deities deity, int amount) {
        PlayerUtil.getAdventPlayer(player).stats().addTribute(deity, amount);
    }

    public static void giveXpToPlayer(ServerPlayerEntity player, Skills skill, float xp) {
        PlayerUtil.getAdventPlayer(player).stats().addXp(skill, xp, false, false);
    }

    public static void addResourceToPlayer(ServerPlayerEntity player, Resources resource, float amount) {
        PlayerUtil.getAdventPlayer(player).stats().regenResource(resource, amount);
    }

    public static boolean consumeResource(ServerPlayerEntity player, Resources resource, float amount, boolean forceConsume) {
        return PlayerUtil.getAdventPlayer(player).stats().consumeResource(resource, amount, forceConsume);
    }

    public static int getLevelProgressPercentage(int lvl, float xp) {
        return lvl >= 1000 ? 100 : (int)(xp / PlayerUtil.getXpRequiredForNextLevel(lvl) * 100.0f);
    }

    public static float getXpRequiredForNextLevel(int currentLevel) {
        if (currentLevel <= 100) {
            return (float)(Math.pow(1.1, currentLevel) * 50.0);
        }
        return currentLevel >= 1000 ? 0.0f : (float)(Math.pow(currentLevel - 10, 2.5) / 100.0) + 630000.0f;
    }

    public static boolean isWearingFullSet(ServerPlayerEntity player, AdventArmour.Type setType) {
        return PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet() == setType;
    }

    public static float getXpRemainingUntilLevel(PlayerDataManager plData, Skills skill) {
        return PlayerUtil.getXpRequiredForNextLevel(plData.stats().getLevel(skill)) - plData.stats().getExp(skill);
    }

    @Nullable
    public static Skills getLowestSkillWithLimit(PlayerDataManager plData, int limit) {
        PlayerDataManager.PlayerStats stats = plData.stats();
        Skills lowestSkill = null;
        int lowestVal = 1001;
        for (Skills sk : Skills.values()) {
            int temp = stats.getLevelForDisplay(sk);
            if (temp < limit || temp >= lowestVal) continue;
            lowestVal = temp;
            lowestSkill = sk;
        }
        if (lowestVal >= 1000) {
            return null;
        }
        return lowestSkill;
    }

    @Nonnull
    public static Skills getHighestSkill(PlayerDataManager plData) {
        PlayerDataManager.PlayerStats stats = plData.stats();
        Skills highestSkill = null;
        int highestVal = 0;
        for (Skills sk : Skills.values()) {
            int lvl = stats.getLevel(sk);
            if (lvl <= highestVal) continue;
            highestSkill = sk;
            highestVal = lvl;
        }
        return highestSkill;
    }

    public static void notifyPlayer(ServerPlayerEntity player, String langKey, Object ... args) {
        PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage(langKey, args);
    }

    public static void clonePlayerData(ServerPlayerEntity sourcePlayer, ServerPlayerEntity targetPlayer) {
        PlayerUtil.getAdventPlayer(targetPlayer).cloneFromExistingPlayerData(PlayerUtil.getAdventPlayer(sourcePlayer));
    }

    public static void notifyPlayerOfInsufficientLevel(ServerPlayerEntity player, Skills skill, int level) {
        AoAPackets.messagePlayer(player, new ToastPopupPacket(skill, level));
    }

    public static void notifyPlayerOfInsufficientResources(ServerPlayerEntity player, Resources resource, float amount) {
        AoAPackets.messagePlayer(player, new ToastPopupPacket(resource, amount));
    }

    public static void notifyPlayerOfInsufficientTribute(ServerPlayerEntity player, Deities deity, int tribute) {
        AoAPackets.messagePlayer(player, new ToastPopupPacket(deity, tribute));
    }

    public static void messageAllPlayersInRange(ITextComponent msg, World world, BlockPos center, int radius) {
        for (PlayerEntity pl : WorldUtil.getAllPlayersInRegion(world, new AxisAlignedBB(center).func_186662_g((double)radius))) {
            pl.func_145747_a(msg);
        }
    }

    public static boolean shouldPlayerBeAffected(PlayerEntity pl) {
        return pl.func_70089_S() && !pl.func_175149_v() && !pl.func_184812_l_();
    }

    public static int getPlayerLevelFromExp(int xp) {
        if (xp > 1507) {
            return (int)Math.floor((162.5 + Math.sqrt(26406.25 - 18.0 * (double)(2220 - xp))) / 9.0);
        }
        if (xp > 352) {
            return (int)Math.floor((40.5 + Math.sqrt(1640.25 - 10.0 * (double)(360 - xp))) / 5.0);
        }
        return (int)Math.floor((-6.0 + Math.sqrt(36 - 4 * -xp)) / 2.0);
    }

    public static BlockPos getBlockAimingAt(PlayerEntity pl, double distance) {
        float angleZ;
        float sinPitch;
        float cosPitch;
        Vec3d startVec = new Vec3d(pl.func_226277_ct_(), pl.func_226278_cu_() + (double)pl.func_70047_e(), pl.func_226281_cx_());
        float cosYaw = MathHelper.func_76134_b((float)(-pl.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-pl.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float angleX = sinYaw * (cosPitch = -MathHelper.func_76134_b((float)(-pl.field_70125_A * ((float)Math.PI / 180))));
        Vec3d endVec = startVec.func_72441_c((double)angleX * distance, (double)(sinPitch = MathHelper.func_76126_a((float)(-pl.field_70125_A * ((float)Math.PI / 180)))) * distance, (double)(angleZ = cosYaw * cosPitch) * distance);
        BlockRayTraceResult ray = pl.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, null));
        if (ray.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return ray.func_216350_a();
    }

    public static void playSoundForPlayer(ServerPlayerEntity player, SoundEvent sound, SoundCategory category, double posX, double posY, double posZ, float volume, float pitch) {
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(sound, category, posX, posY, posZ, volume, pitch));
    }

    @Nullable
    public static PlayerEntity getPlayerOrOwnerIfApplicable(@Nullable Entity entity) {
        LivingEntity owner;
        if (entity == null) {
            return null;
        }
        if (entity instanceof PlayerEntity) {
            return (PlayerEntity)entity;
        }
        if (entity instanceof TameableEntity && (owner = ((TameableEntity)entity).func_70902_q()) instanceof PlayerEntity) {
            return (PlayerEntity)owner;
        }
        return null;
    }

    public static EquipmentSlotType handToEquipmentSlotType(Hand hand) {
        return hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
    }
}

