/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util.skill;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Tuple;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

public class HunterUtil {
    private static final HashMap<EntityType<? extends MobEntity>, Tuple<Integer, Float>> hunterCreatureMap = new HashMap();

    public static boolean canAttackTarget(@Nonnull LivingEntity target, @Nullable Entity attacker, boolean notifyPlayer) {
        boolean success;
        PlayerEntity player;
        if (attacker == null || !hunterCreatureMap.containsKey(target.func_200600_R())) {
            return true;
        }
        int lvl = (Integer)hunterCreatureMap.get(target.func_200600_R()).func_76341_a();
        Object object = attacker instanceof PlayerEntity ? (PlayerEntity)attacker : (attacker instanceof TameableEntity ? (((TameableEntity)attacker).func_70902_q() instanceof PlayerEntity ? (PlayerEntity)((TameableEntity)attacker).func_70902_q() : null) : (player = null));
        if (player == null) {
            return false;
        }
        boolean bl = success = player.func_184812_l_() || !target.field_70170_p.field_72995_K && PlayerUtil.doesPlayerHaveLevel((ServerPlayerEntity)player, Skills.HUNTER, lvl);
        if (!success && notifyPlayer && !player.field_70170_p.field_72995_K) {
            PlayerUtil.notifyPlayerOfInsufficientLevel((ServerPlayerEntity)player, Skills.HUNTER, lvl);
        }
        return success;
    }

    public static boolean isHunterCreature(@Nonnull LivingEntity entity) {
        return hunterCreatureMap.containsKey(entity.func_200600_R());
    }

    public static int getHunterLevel(@Nullable LivingEntity entity) {
        if (entity == null || !hunterCreatureMap.containsKey(entity.func_200600_R())) {
            return -1;
        }
        return (Integer)hunterCreatureMap.get(entity.func_200600_R()).func_76341_a();
    }

    public static float getHunterXp(@Nullable LivingEntity entity) {
        if (entity == null || !hunterCreatureMap.containsKey(entity.func_200600_R())) {
            return -1.0f;
        }
        return ((Float)hunterCreatureMap.get(entity.func_200600_R()).func_76340_b()).floatValue();
    }

    static {
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ANEMIA.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(23.1f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.BLOODMIST.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(9.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.DARK_BEAST.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(11.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.HOST.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(19.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.IRKLING.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(9.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.LINGER.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(10.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.MODULO.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(11.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.NIGHT_WATCHER.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(9.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.RAMMERHEAD.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(10.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ROLOSCOPE.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(9.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SCRUBBY.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(7.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SKELLOX.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(7.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.TERRESTRIAL.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(13.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.URKA.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(8.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.VERTEBRON.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(9.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.VOID_WALKER.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(6.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.WALKER.get(), (Tuple<Integer, Float>)new Tuple((Object)1, (Object)Float.valueOf(6.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.DEATH_HUNTER.get(), (Tuple<Integer, Float>)new Tuple((Object)3, (Object)Float.valueOf(11.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.HEADLESS_DESTROYER.get(), (Tuple<Integer, Float>)new Tuple((Object)3, (Object)Float.valueOf(12.1f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.REAPER_TWINS.get(), (Tuple<Integer, Float>)new Tuple((Object)3, (Object)Float.valueOf(9.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.TRICLOPS.get(), (Tuple<Integer, Float>)new Tuple((Object)3, (Object)Float.valueOf(7.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.MOTHER_VOID_WALKER.get(), (Tuple<Integer, Float>)new Tuple((Object)5, (Object)Float.valueOf(9.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ICE_GIANT.get(), (Tuple<Integer, Float>)new Tuple((Object)9, (Object)Float.valueOf(8.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.LEAFY_GIANT.get(), (Tuple<Integer, Float>)new Tuple((Object)9, (Object)Float.valueOf(7.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SAND_GIANT.get(), (Tuple<Integer, Float>)new Tuple((Object)9, (Object)Float.valueOf(10.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.STONE_GIANT.get(), (Tuple<Integer, Float>)new Tuple((Object)9, (Object)Float.valueOf(15.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.WOOD_GIANT.get(), (Tuple<Integer, Float>)new Tuple((Object)9, (Object)Float.valueOf(12.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.AMPHIBIYTE.get(), (Tuple<Integer, Float>)new Tuple((Object)12, (Object)Float.valueOf(8.1f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SKELETAL_COWMAN.get(), (Tuple<Integer, Float>)new Tuple((Object)13, (Object)Float.valueOf(12.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.KAIYU.get(), (Tuple<Integer, Float>)new Tuple((Object)17, (Object)Float.valueOf(10.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ZHINX.get(), (Tuple<Integer, Float>)new Tuple((Object)19, (Object)Float.valueOf(17.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.EXOHEAD.get(), (Tuple<Integer, Float>)new Tuple((Object)23, (Object)Float.valueOf(15.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.NETHENGEIC_BEAST.get(), (Tuple<Integer, Float>)new Tuple((Object)24, (Object)Float.valueOf(16.3f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.DIOCUS.get(), (Tuple<Integer, Float>)new Tuple((Object)27, (Object)Float.valueOf(29.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.PARAVITE.get(), (Tuple<Integer, Float>)new Tuple((Object)28, (Object)Float.valueOf(21.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SPINOLEDON.get(), (Tuple<Integer, Float>)new Tuple((Object)28, (Object)Float.valueOf(21.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.IOSAUR.get(), (Tuple<Integer, Float>)new Tuple((Object)29, (Object)Float.valueOf(24.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.MUSHROOM_SPIDER.get(), (Tuple<Integer, Float>)new Tuple((Object)29, (Object)Float.valueOf(21.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.RAWBONE.get(), (Tuple<Integer, Float>)new Tuple((Object)30, (Object)Float.valueOf(24.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ENFORCER.get(), (Tuple<Integer, Float>)new Tuple((Object)31, (Object)Float.valueOf(26.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.UNDEAD_TROLL.get(), (Tuple<Integer, Float>)new Tuple((Object)32, (Object)Float.valueOf(28.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.JAWE.get(), (Tuple<Integer, Float>)new Tuple((Object)33, (Object)Float.valueOf(30.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.BANSHEE.get(), (Tuple<Integer, Float>)new Tuple((Object)34, (Object)Float.valueOf(39.1f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.NIGHTMARE_SPIDER.get(), (Tuple<Integer, Float>)new Tuple((Object)34, (Object)Float.valueOf(26.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.DAWNLIGHT.get(), (Tuple<Integer, Float>)new Tuple((Object)35, (Object)Float.valueOf(35.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.NIGHTWING.get(), (Tuple<Integer, Float>)new Tuple((Object)39, (Object)Float.valueOf(47.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.FLESH_EATER.get(), (Tuple<Integer, Float>)new Tuple((Object)40, (Object)Float.valueOf(51.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.JUMBO.get(), (Tuple<Integer, Float>)new Tuple((Object)42, (Object)Float.valueOf(90.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.PHANTOM.get(), (Tuple<Integer, Float>)new Tuple((Object)44, (Object)Float.valueOf(70.3f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.CANE_BUG.get(), (Tuple<Integer, Float>)new Tuple((Object)47, (Object)Float.valueOf(88.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.GINGERBIRD.get(), (Tuple<Integer, Float>)new Tuple((Object)50, (Object)Float.valueOf(112.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.GINGERBREAD_MAN.get(), (Tuple<Integer, Float>)new Tuple((Object)53, (Object)Float.valueOf(143.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.POD_PLANT.get(), (Tuple<Integer, Float>)new Tuple((Object)56, (Object)Float.valueOf(183.1f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.VINE_WIZARD.get(), (Tuple<Integer, Float>)new Tuple((Object)59, (Object)Float.valueOf(233.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SPECTRAL_WIZARD.get(), (Tuple<Integer, Float>)new Tuple((Object)64, (Object)Float.valueOf(353.3f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.RUNIC_GUARDIAN.get(), (Tuple<Integer, Float>)new Tuple((Object)66, (Object)Float.valueOf(417.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.MERMAGE.get(), (Tuple<Integer, Float>)new Tuple((Object)67, (Object)Float.valueOf(453.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.AMPHIBIOR.get(), (Tuple<Integer, Float>)new Tuple((Object)69, (Object)Float.valueOf(536.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.FACELESS_FLOATER.get(), (Tuple<Integer, Float>)new Tuple((Object)71, (Object)Float.valueOf(634.0f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ZORP.get(), (Tuple<Integer, Float>)new Tuple((Object)75, (Object)Float.valueOf(888.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ZARG.get(), (Tuple<Integer, Float>)new Tuple((Object)76, (Object)Float.valueOf(966.9f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.BAUMBA.get(), (Tuple<Integer, Float>)new Tuple((Object)78, (Object)Float.valueOf(1145.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.REFLUCT.get(), (Tuple<Integer, Float>)new Tuple((Object)79, (Object)Float.valueOf(1247.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.INMATE_X.get(), (Tuple<Integer, Float>)new Tuple((Object)81, (Object)Float.valueOf(1443.4f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.INMATE_Y.get(), (Tuple<Integer, Float>)new Tuple((Object)81, (Object)Float.valueOf(1640.8f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.MERKYRE.get(), (Tuple<Integer, Float>)new Tuple((Object)83, (Object)Float.valueOf(1755.3f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.CRUSILISK.get(), (Tuple<Integer, Float>)new Tuple((Object)84, (Object)Float.valueOf(1912.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.ARKZYNE.get(), (Tuple<Integer, Float>)new Tuple((Object)86, (Object)Float.valueOf(2270.2f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.SHYRE_TROLL.get(), (Tuple<Integer, Float>)new Tuple((Object)90, (Object)Float.valueOf(3203.6f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.LIGHTWALKER.get(), (Tuple<Integer, Float>)new Tuple((Object)94, (Object)Float.valueOf(4527.5f)));
        hunterCreatureMap.put((EntityType<? extends MobEntity>)AoAEntities.Mobs.LUXOCRON.get(), (Tuple<Integer, Float>)new Tuple((Object)97, (Object)Float.valueOf(5873.8f)));
    }
}

