/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.tslat.aoa3.worldgen.WorldGenerator;

public class WorldGenMinable
extends WorldGenerator {
    private final BlockState oreBlock;
    private final int numberOfBlocks;
    private final Predicate<BlockState> predicate;

    public WorldGenMinable(BlockState state, int blockCount, Predicate<BlockState> predicate) {
        this.oreBlock = state;
        this.numberOfBlocks = blockCount;
        this.predicate = predicate;
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos position) {
        float angle = rand.nextFloat() * (float)Math.PI;
        double minX = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)angle) * (float)this.numberOfBlocks / 8.0f;
        double maxX = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)angle) * (float)this.numberOfBlocks / 8.0f;
        double minZ = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)angle) * (float)this.numberOfBlocks / 8.0f;
        double maxZ = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)angle) * (float)this.numberOfBlocks / 8.0f;
        double minY = position.func_177956_o() + rand.nextInt(3) - 2;
        double maxY = position.func_177956_o() + rand.nextInt(3) - 2;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            float veinProgress = (float)i / (float)this.numberOfBlocks;
            double xLerp = minX + (maxX - minX) * (double)veinProgress;
            double yLerp = minY + (maxY - minY) * (double)veinProgress;
            double zLerp = minZ + (maxZ - minZ) * (double)veinProgress;
            double reachMod = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double lateralSpan = (double)(MathHelper.func_76126_a((float)((float)Math.PI * veinProgress)) + 1.0f) * reachMod + 1.0;
            double verticalSpan = (double)(MathHelper.func_76126_a((float)((float)Math.PI * veinProgress)) + 1.0f) * reachMod + 1.0;
            int startX = MathHelper.func_76128_c((double)(xLerp - lateralSpan / 2.0));
            int startY = MathHelper.func_76128_c((double)(yLerp - verticalSpan / 2.0));
            int startZ = MathHelper.func_76128_c((double)(zLerp - lateralSpan / 2.0));
            int endX = MathHelper.func_76128_c((double)(xLerp + lateralSpan / 2.0));
            int endY = MathHelper.func_76128_c((double)(yLerp + verticalSpan / 2.0));
            int endZ = MathHelper.func_76128_c((double)(zLerp + lateralSpan / 2.0));
            for (int x = startX; x <= endX; ++x) {
                double xDist = ((double)x + 0.5 - xLerp) / (lateralSpan / 2.0);
                if (!(xDist * xDist < 1.0)) continue;
                for (int y = startY; y <= endY; ++y) {
                    double yDist = ((double)y + 0.5 - yLerp) / (verticalSpan / 2.0);
                    if (!(xDist * xDist + yDist * yDist < 1.0)) continue;
                    for (int z = startZ; z <= endZ; ++z) {
                        BlockPos pos;
                        BlockState state;
                        double zDist = ((double)z + 0.5 - zLerp) / (lateralSpan / 2.0);
                        if (!(xDist * xDist + yDist * yDist + zDist * zDist < 1.0) || !(state = world.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c().isReplaceableOreGen(state, (IWorldReader)world, pos, this.predicate)) continue;
                        world.func_180501_a(pos, this.oreBlock, 2);
                    }
                }
            }
        }
        return true;
    }
}

