/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;

public abstract class WorldGenerator {
    private final boolean doBlockNotify;
    protected ChunkPos chunkPos = null;

    public WorldGenerator() {
        this(false);
    }

    public WorldGenerator(boolean notify) {
        this.doBlockNotify = notify;
    }

    public WorldGenerator setChunkPos(ChunkPos pos) {
        this.chunkPos = pos;
        return this;
    }

    public abstract boolean generate(IWorld var1, Random var2, BlockPos var3);

    public void setDecorationDefaults() {
    }

    protected void setBlockAndNotifyAdequately(IWorld world, BlockPos pos, BlockState state) {
        if (this.chunkPos != null && (pos.func_177958_n() < this.chunkPos.func_180334_c() || pos.func_177958_n() > this.chunkPos.func_180332_e() || pos.func_177952_p() < this.chunkPos.func_180333_d() || pos.func_177952_p() > this.chunkPos.func_180330_f())) {
            return;
        }
        world.func_180501_a(pos, state, 2);
    }

    @Nullable
    protected TileEntity getTileEntity(IWorld world, BlockPos pos) {
        if (this.chunkPos != null && (pos.func_177958_n() < this.chunkPos.func_180334_c() || pos.func_177958_n() > this.chunkPos.func_180332_e() || pos.func_177952_p() < this.chunkPos.func_180333_d() || pos.func_177952_p() > this.chunkPos.func_180330_f())) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    protected void spawnEntity(IWorld world, Entity entity, double x, double y, double z) {
        if (this.chunkPos != null && (x < (double)this.chunkPos.func_180334_c() || x > (double)this.chunkPos.func_180332_e() || z < (double)this.chunkPos.func_180333_d() || z > (double)this.chunkPos.func_180330_f())) {
            return;
        }
        entity.func_70080_a(x, y, z, 0.0f, 0.0f);
        world.func_217376_c(entity);
    }
}

