/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.chunkgenerator;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.chunkgenerator.config.CavernGenerationSettings;

public class CavernChunkBuilder
extends NoiseChunkGenerator<CavernGenerationSettings> {
    private static final float[] weightMap = (float[])Util.func_200696_a((Object)new float[25], weights -> {
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                float surroundingAverage;
                weights[xOffset + 2 + (zOffset + 2) * 5] = surroundingAverage = 10.0f / MathHelper.func_76129_c((float)((float)(xOffset * xOffset + zOffset * zOffset) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator noiseGenerator;

    public CavernChunkBuilder(IWorld world, BiomeProvider provider, CavernGenerationSettings genSettings) {
        super(world, provider, 4, 8, 256, (GenerationSettings)genSettings, true);
        this.field_222558_e.func_202423_a(2620);
        this.noiseGenerator = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
    }

    public void func_202093_c(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(chunkX, chunkZ).func_206849_h());
        SharedSeedRandom seededRandom = new SharedSeedRandom();
        seededRandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)seededRandom);
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return 20;
    }

    protected void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        double lateralScale = 684.412f;
        double verticalScale = 684.412f;
        double lateralScaleModifier = lateralScale / 80.0;
        double heightScaleModifier = verticalScale / 160.0;
        int additionalVerticalNoiseLerpCap = -10;
        int lerpDivisor = 3;
        this.func_222546_a(noiseColumn, noiseX, noiseZ, lateralScale, verticalScale, lateralScaleModifier, heightScaleModifier, lerpDivisor, additionalVerticalNoiseLerpCap);
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        int seaLevel = this.func_222530_f();
        ObjectArrayList villagePieces = new ObjectArrayList(10);
        ObjectArrayList jigsawJunctions = new ObjectArrayList(32);
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String structureName = structure.func_143025_a();
            LongIterator structureReferences = chunk.func_201578_b(structureName).iterator();
            while (structureReferences.hasNext()) {
                long structurePos = structureReferences.nextLong();
                ChunkPos structureChunkPos = new ChunkPos(structurePos);
                StructureStart structureStart = world.func_212866_a_(structureChunkPos.field_77276_a, structureChunkPos.field_77275_b).func_201585_a(structureName);
                if (structureStart == null || !structureStart.func_75069_d()) continue;
                for (StructurePiece piece : structureStart.func_186161_c()) {
                    if (!piece.func_214810_a(chunkPos, 12) || !(piece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece villagePiece = (AbstractVillagePiece)piece;
                    if (villagePiece.func_214826_b().func_214854_c() == JigsawPattern.PlacementBehaviour.RIGID) {
                        villagePieces.add((Object)villagePiece);
                    }
                    for (JigsawJunction junction : villagePiece.func_214829_e()) {
                        int villageStartX = junction.func_214895_a();
                        int villageStartZ = junction.func_214893_c();
                        if (villageStartX <= baseX - 12 || villageStartZ <= baseZ - 12 || villageStartX >= baseX + 15 + 12 || villageStartZ >= baseZ + 15 + 12) continue;
                        jigsawJunctions.add((Object)junction);
                    }
                }
            }
        }
        double[][][] noiseMap = new double[2][this.field_222567_n + 1][this.field_222566_m + 1];
        for (int i = 0; i < this.field_222567_n + 1; ++i) {
            noiseMap[0][i] = new double[this.field_222566_m + 1];
            this.func_222548_a(noiseMap[0][i], chunkX * this.field_222565_l, chunkZ * this.field_222567_n + i);
            noiseMap[1][i] = new double[this.field_222566_m + 1];
        }
        ChunkPrimer chunkPrimer = (ChunkPrimer)chunk;
        Heightmap oceanFloorHeightmap = chunkPrimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap surfaceHeightmap = chunkPrimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        ObjectListIterator villagePieceIterator = villagePieces.iterator();
        ObjectListIterator jigsawJunctionIterator = jigsawJunctions.iterator();
        for (int xNoiseMod = 0; xNoiseMod < this.field_222565_l; ++xNoiseMod) {
            for (int zNoisePos = 0; zNoisePos < this.field_222567_n + 1; ++zNoisePos) {
                this.func_222548_a(noiseMap[1][zNoisePos], chunkX * this.field_222565_l + xNoiseMod + 1, chunkZ * this.field_222567_n + zNoisePos);
            }
            for (int zNoiseMod = 0; zNoiseMod < this.field_222567_n; ++zNoiseMod) {
                ChunkSection chunkSection = chunkPrimer.func_217332_a(15);
                chunkSection.func_222635_a();
                for (int posY = this.field_222566_m - 1; posY >= 0; --posY) {
                    double d16 = noiseMap[0][zNoiseMod][posY];
                    double d17 = noiseMap[0][zNoiseMod + 1][posY];
                    double d18 = noiseMap[1][zNoiseMod][posY];
                    double d0 = noiseMap[1][zNoiseMod + 1][posY];
                    double d1 = noiseMap[0][zNoiseMod][posY + 1];
                    double d2 = noiseMap[0][zNoiseMod + 1][posY + 1];
                    double d3 = noiseMap[1][zNoiseMod][posY + 1];
                    double d4 = noiseMap[1][zNoiseMod + 1][posY + 1];
                    for (int posYNoiseOffset = this.field_222563_j - 1; posYNoiseOffset >= 0; --posYNoiseOffset) {
                        int finalPosY = posY * this.field_222563_j + posYNoiseOffset;
                        int chunkRelativeYPos = finalPosY & 0xF;
                        int verticalChunkPos = finalPosY >> 4;
                        if (chunkSection.func_222632_g() >> 4 != verticalChunkPos) {
                            chunkSection.func_222637_b();
                            chunkSection = chunkPrimer.func_217332_a(verticalChunkPos);
                            chunkSection.func_222635_a();
                        }
                        double yNoisePosRatio = (double)posYNoiseOffset / (double)this.field_222563_j;
                        double d6 = MathHelper.func_219803_d((double)yNoisePosRatio, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)yNoisePosRatio, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)yNoisePosRatio, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)yNoisePosRatio, (double)d0, (double)d4);
                        for (int posXNoiseOffset = 0; posXNoiseOffset < this.field_222564_k; ++posXNoiseOffset) {
                            int finalPosX = baseX + xNoiseMod * this.field_222564_k + posXNoiseOffset;
                            int chunkRelativeXPos = finalPosX & 0xF;
                            double xNoisePosRatio = (double)posXNoiseOffset / (double)this.field_222564_k;
                            double d11 = MathHelper.func_219803_d((double)xNoisePosRatio, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)xNoisePosRatio, (double)d8, (double)d9);
                            for (int posZNoiseOffset = 0; posZNoiseOffset < this.field_222564_k; ++posZNoiseOffset) {
                                int structureYStart;
                                int structureXStart;
                                int finalPosZ = baseZ + zNoiseMod * this.field_222564_k + posZNoiseOffset;
                                int chunkRelativeZPos = finalPosZ & 0xF;
                                double zNoisePosRatio = (double)posZNoiseOffset / (double)this.field_222564_k;
                                double d14 = MathHelper.func_219803_d((double)zNoisePosRatio, (double)d11, (double)d12);
                                double d15 = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                d15 = d15 / 2.0 - d15 * d15 * d15 / 24.0;
                                while (villagePieceIterator.hasNext()) {
                                    AbstractVillagePiece curVillagePiece = (AbstractVillagePiece)villagePieceIterator.next();
                                    MutableBoundingBox villagePieceBoundingBox = curVillagePiece.func_74874_b();
                                    structureXStart = Math.max(0, Math.max(villagePieceBoundingBox.field_78897_a - finalPosX, finalPosX - villagePieceBoundingBox.field_78893_d));
                                    structureYStart = finalPosY - (villagePieceBoundingBox.field_78895_b + curVillagePiece.func_214830_d());
                                    int structureZStart = Math.max(0, Math.max(villagePieceBoundingBox.field_78896_c - finalPosZ, finalPosZ - villagePieceBoundingBox.field_78892_f));
                                    d15 += CavernChunkBuilder.func_222556_a((int)structureXStart, (int)structureYStart, (int)structureZStart) * 0.8;
                                }
                                villagePieceIterator.back(villagePieces.size());
                                while (jigsawJunctionIterator.hasNext()) {
                                    JigsawJunction curJunction = (JigsawJunction)jigsawJunctionIterator.next();
                                    int junctionXStart = finalPosX - curJunction.func_214895_a();
                                    structureXStart = finalPosY - curJunction.func_214896_b();
                                    structureYStart = finalPosZ - curJunction.func_214893_c();
                                    d15 += CavernChunkBuilder.func_222556_a((int)junctionXStart, (int)structureXStart, (int)structureYStart) * 0.4;
                                }
                                jigsawJunctionIterator.back(jigsawJunctions.size());
                                BlockState state = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    if (finalPosY < ((CavernGenerationSettings)this.field_222543_d).getCeilingHeight()) {
                                        state = this.field_222559_f;
                                    }
                                } else if (finalPosY < ((CavernGenerationSettings)this.field_222543_d).getFloorHeight()) {
                                    state = this.field_222559_f;
                                } else if (finalPosY < seaLevel && finalPosY < ((CavernGenerationSettings)this.field_222543_d).getCeilingHeight()) {
                                    state = this.field_222559_f;
                                }
                                if (state == Blocks.field_150350_a.func_176223_P()) continue;
                                mutablePos.func_181079_c(finalPosX, finalPosY, finalPosZ);
                                if (state.getLightValue((IBlockReader)chunkPrimer, (BlockPos)mutablePos) != 0) {
                                    chunkPrimer.func_201637_h((BlockPos)mutablePos);
                                }
                                chunkSection.func_177484_a(chunkRelativeXPos, chunkRelativeYPos, chunkRelativeZPos, state, false);
                                oceanFloorHeightmap.func_202270_a(chunkRelativeXPos, finalPosY, chunkRelativeZPos, state);
                                surfaceHeightmap.func_202270_a(chunkRelativeXPos, finalPosY, chunkRelativeZPos, state);
                            }
                        }
                    }
                }
                chunkSection.func_222637_b();
            }
            double[][] adouble1 = noiseMap[0];
            noiseMap[0] = noiseMap[1];
            noiseMap[1] = adouble1;
        }
    }

    protected double func_222545_a(double heightAverage, double accumulatedHeightVariation, int noisePos) {
        double baseSize = 8.5;
        double heightStretch = 12.0;
        double noiseHeight = ((double)noisePos - (baseSize + heightAverage * baseSize / 8.0 * 4.0)) * heightStretch * 128.0 / 256.0 / accumulatedHeightVariation;
        if (noiseHeight < 0.0) {
            noiseHeight *= 4.0;
        }
        return noiseHeight;
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] noisePair = new double[2];
        float accumulatedHeightVariation = 0.0f;
        float accumulatedHeight = 0.0f;
        float accumulatedHeightFactor = 0.0f;
        int seaLevel = this.func_222530_f();
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + xOffset, 64, noiseZ + zOffset);
                float offsetBaseHeight = biome.func_185355_j();
                float heightVariation = -1.0f - biome.func_185360_m();
                float heightFactor = weightMap[xOffset + 2 + (zOffset + 2) * 5] / (offsetBaseHeight + 2.0f);
                if (biome.func_185355_j() > this.field_222542_c.func_225526_b_(noiseX, seaLevel, noiseZ).func_185355_j()) {
                    heightFactor /= 2.0f;
                }
                accumulatedHeightVariation += heightVariation * heightFactor;
                accumulatedHeight += offsetBaseHeight * heightFactor;
                accumulatedHeightFactor += heightFactor;
            }
        }
        accumulatedHeightVariation /= accumulatedHeightFactor;
        accumulatedHeight /= accumulatedHeightFactor;
        accumulatedHeightVariation = accumulatedHeightVariation * 0.9f + 0.1f;
        accumulatedHeight = (accumulatedHeight * 4.0f - 1.0f) / 8.0f;
        noisePair[0] = (double)accumulatedHeight + this.getNoiseDepthAt(noiseX, noiseZ);
        noisePair[1] = accumulatedHeightVariation;
        return noisePair;
    }

    private double getNoiseDepthAt(int noiseX, int noiseZ) {
        double noiseDepth = this.noiseGenerator.func_215462_a((double)(noiseX * 200), 10.0, (double)(noiseZ * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (noiseDepth < 0.0) {
            noiseDepth *= -0.3;
        }
        if ((noiseDepth = noiseDepth * 3.0 - 2.0) < 0.0) {
            noiseDepth /= 28.0;
        } else {
            if (noiseDepth > 1.0) {
                noiseDepth = 1.0;
            }
            noiseDepth /= 40.0;
        }
        return noiseDepth;
    }

    public void func_227058_a_(BiomeManager biomeManager, IChunk chunk, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager) {
        super.func_227058_a_(biomeManager, chunk, chunkGenerator, templateManager);
        Biome centerBiome = biomeManager.func_226836_a_(new BlockPos(chunk.func_76632_l().func_180334_c() + 8, 0, chunk.func_76632_l().func_180333_d() + 8));
        if (centerBiome instanceof AoABiome) {
            ((AoABiome)centerBiome).generateStructures(this.field_222540_a, biomeManager, chunk, chunkGenerator, templateManager);
        }
    }

    protected void func_222555_a(IChunk chunk, Random rand) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState dimFabric = ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P();
        for (int x = chunkPos.func_180334_c(); x <= chunkPos.func_180332_e(); ++x) {
            for (int z = chunkPos.func_180333_d(); z <= chunkPos.func_180330_f(); ++z) {
                for (int y = 0; y <= 1; ++y) {
                    chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), dimFabric, false);
                    chunk.func_177436_a((BlockPos)pos.func_181079_c(x, 129 + y, z), dimFabric, false);
                }
            }
        }
    }

    public int func_205470_d() {
        return 64;
    }
}

