/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.chunkgenerator;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.AoABiome;

public class GenericAoAChunkBuilder
extends NoiseChunkGenerator<GenerationSettings> {
    private static final float[] weightMap = (float[])Util.func_200696_a((Object)new float[25], weights -> {
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                float surroundingAverage;
                weights[xOffset + 2 + (zOffset + 2) * 5] = surroundingAverage = 10.0f / MathHelper.func_76129_c((float)((float)(xOffset * xOffset + zOffset * zOffset) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator noiseGenerator;
    private final boolean isAmplified;

    public GenericAoAChunkBuilder(IWorld world, BiomeProvider provider, GenerationSettings genSettings) {
        super(world, provider, 4, 8, 256, genSettings, true);
        this.field_222558_e.func_202423_a(2620);
        this.noiseGenerator = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.isAmplified = world.func_72912_H().func_76067_t() == WorldType.field_151360_e;
    }

    public void func_202093_c(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(chunkX, chunkZ).func_206849_h());
        SharedSeedRandom seededRandom = new SharedSeedRandom();
        seededRandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)seededRandom);
    }

    protected void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        double lateralScale = 684.412f;
        double verticalScale = 684.412f;
        double lateralScaleModifier = lateralScale / 80.0;
        double heightScaleModifier = verticalScale / 160.0;
        int additionalVerticalNoiseLerpCap = -10;
        int lerpDivisor = 3;
        this.func_222546_a(noiseColumn, noiseX, noiseZ, lateralScale, verticalScale, lateralScaleModifier, heightScaleModifier, lerpDivisor, additionalVerticalNoiseLerpCap);
    }

    protected double func_222545_a(double heightAverage, double accumulatedHeightVariation, int noisePos) {
        double baseSize = 8.5;
        double heightStretch = 12.0;
        double noiseHeight = ((double)noisePos - (baseSize + heightAverage * baseSize / 8.0 * 4.0)) * heightStretch * 128.0 / 256.0 / accumulatedHeightVariation;
        if (noiseHeight < 0.0) {
            noiseHeight *= 4.0;
        }
        return noiseHeight;
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] noisePair = new double[2];
        float accumulatedHeightVariation = 0.0f;
        float accumulatedHeight = 0.0f;
        float accumulatedHeightFactor = 0.0f;
        int seaLevel = this.func_222530_f();
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + xOffset, 64, noiseZ + zOffset);
                float offsetBaseHeight = biome.func_185355_j();
                float heightVariation = biome.func_185360_m();
                if (this.isAmplified && offsetBaseHeight > 0.0f) {
                    offsetBaseHeight = 1.0f + offsetBaseHeight * 2.0f;
                    heightVariation = 1.0f + heightVariation * 4.0f;
                }
                float heightFactor = weightMap[xOffset + 2 + (zOffset + 2) * 5] / (offsetBaseHeight + 2.0f);
                if (biome.func_185355_j() > this.field_222542_c.func_225526_b_(noiseX, seaLevel, noiseZ).func_185355_j()) {
                    heightFactor /= 2.0f;
                }
                accumulatedHeightVariation += heightVariation * heightFactor;
                accumulatedHeight += offsetBaseHeight * heightFactor;
                accumulatedHeightFactor += heightFactor;
            }
        }
        accumulatedHeightVariation /= accumulatedHeightFactor;
        accumulatedHeight /= accumulatedHeightFactor;
        accumulatedHeightVariation = accumulatedHeightVariation * 0.9f + 0.1f;
        accumulatedHeight = (accumulatedHeight * 4.0f - 1.0f) / 8.0f;
        noisePair[0] = (double)accumulatedHeight + this.getNoiseDepthAt(noiseX, noiseZ);
        noisePair[1] = accumulatedHeightVariation;
        return noisePair;
    }

    private double getNoiseDepthAt(int noiseX, int noiseZ) {
        double noiseDepth = this.noiseGenerator.func_215462_a((double)(noiseX * 200), 10.0, (double)(noiseZ * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (noiseDepth < 0.0) {
            noiseDepth *= -0.3;
        }
        if ((noiseDepth = noiseDepth * 3.0 - 2.0) < 0.0) {
            noiseDepth /= 28.0;
        } else {
            if (noiseDepth > 1.0) {
                noiseDepth = 1.0;
            }
            noiseDepth /= 40.0;
        }
        return noiseDepth;
    }

    public void func_227058_a_(BiomeManager biomeManager, IChunk chunk, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager) {
        super.func_227058_a_(biomeManager, chunk, chunkGenerator, templateManager);
        Biome centerBiome = biomeManager.func_226836_a_(new BlockPos(chunk.func_76632_l().func_180334_c() + 8, 0, chunk.func_76632_l().func_180333_d() + 8));
        if (centerBiome instanceof AoABiome) {
            ((AoABiome)centerBiome).generateStructures(this.field_222540_a, biomeManager, chunk, chunkGenerator, templateManager);
        }
    }

    protected void func_222555_a(IChunk chunk, Random rand) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState dimFabric = ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P();
        for (int x = chunkPos.func_180334_c(); x <= chunkPos.func_180332_e(); ++x) {
            for (int z = chunkPos.func_180333_d(); z <= chunkPos.func_180330_f(); ++z) {
                for (int y = 0; y <= 1; ++y) {
                    chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), dimFabric, false);
                }
            }
        }
    }

    public int func_205470_d() {
        return 64;
    }
}

