/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.chunkgenerator;

import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.tslat.aoa3.worldgen.AoABiome;

public class StructureChunkBuilder
extends ChunkGenerator<GenerationSettings> {
    public StructureChunkBuilder(IWorld world, BiomeProvider provider, GenerationSettings genSettings) {
        super(world, provider, genSettings);
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        SharedSeedRandom random = new SharedSeedRandom(this.field_222541_b);
        ChunkPrimer primer = (ChunkPrimer)chunk;
        Biome biome = world.func_226691_t_(chunk.func_76632_l().func_206849_h());
        primer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        random.func_202422_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        Heightmap groundHeightmap = primer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                primer.func_217332_a(15);
                for (int i = 0; i < 256; i += 15) {
                    primer.func_217332_a(i >> 4);
                }
            }
        }
        if (biome instanceof AoABiome) {
            ((AoABiome)biome).generateStructuredChunk(world, primer, random, (pos, state) -> {
                BlockPos globalPos = new BlockPos((Vec3i)primer.func_76632_l().func_206849_h().func_177971_a((Vec3i)pos));
                ChunkSection chunkSection = primer.func_217332_a(pos.func_177956_o() >> 4);
                if (state.getLightValue((IBlockReader)primer, globalPos) != 0) {
                    primer.func_201637_h(globalPos);
                }
                chunkSection.func_177484_a(pos.func_177958_n(), pos.func_177956_o() & 0xF, pos.func_177952_p(), state, false);
                groundHeightmap.func_202270_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state);
            });
        }
    }

    public void func_225551_a_(WorldGenRegion world, IChunk chunk) {
    }

    public void func_202093_c(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(chunkX, chunkZ).func_206849_h());
        SharedSeedRandom seededRandom = new SharedSeedRandom();
        seededRandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)seededRandom);
    }

    public void func_227058_a_(BiomeManager biomeManager, IChunk chunk, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager) {
        super.func_227058_a_(biomeManager, chunk, chunkGenerator, templateManager);
        Biome centerBiome = biomeManager.func_226836_a_(new BlockPos(chunk.func_76632_l().func_180334_c() + 8, 0, chunk.func_76632_l().func_180333_d() + 8));
        if (centerBiome instanceof AoABiome) {
            ((AoABiome)centerBiome).generateStructures(this.field_222540_a, biomeManager, chunk, chunkGenerator, templateManager);
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        ServerChunkProvider provider;
        ChunkHolder holder;
        if (this.field_222540_a.func_72863_F() instanceof ServerChunkProvider && (holder = (provider = (ServerChunkProvider)this.field_222540_a.func_72863_F()).func_217213_a(new ChunkPos(new BlockPos(x, 0, z)).func_201841_a())) != null && ChunkHolder.func_219278_b((int)holder.func_219299_i()).func_209003_a(ChunkStatus.field_222610_f)) {
            return this.field_222540_a.func_217348_a(x >> 4, z >> 4, ChunkStatus.field_222610_f).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1;
        }
        return 0;
    }

    public int func_205470_d() {
        return 0;
    }
}

