/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.LakesFeature;

public class BiomeFriendlyLakeFeature
extends LakesFeature {
    public BiomeFriendlyLakeFeature(Function<Dynamic<?>, ? extends BlockStateFeatureConfig> configFunction) {
        super(configFunction);
    }

    public boolean func_212245_a(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos basePos, BlockStateFeatureConfig config) {
        block23: {
            int x;
            block22: {
                int y;
                while (basePos.func_177956_o() > 5 && world.func_175623_d(basePos)) {
                    basePos = basePos.func_177977_b();
                }
                if (basePos.func_177956_o() <= 4) {
                    return false;
                }
                basePos = basePos.func_177979_c(4);
                ChunkPos chunkPos = new ChunkPos(basePos);
                if (!world.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222607_c).func_201578_b(Feature.field_214550_p.func_143025_a()).isEmpty()) {
                    return false;
                }
                boolean[] positions = new boolean[2048];
                int i = rand.nextInt(4) + 4;
                for (int j = 0; j < i; ++j) {
                    double radiusX = rand.nextDouble() * 6.0 + 3.0;
                    double radiusY = rand.nextDouble() * 4.0 + 2.0;
                    double radiusZ = rand.nextDouble() * 6.0 + 3.0;
                    double centerX = rand.nextDouble() * (16.0 - radiusX - 2.0) + 1.0 + radiusX / 2.0;
                    double centerY = rand.nextDouble() * (8.0 - radiusY - 4.0) + 2.0 + radiusY / 2.0;
                    double centerZ = rand.nextDouble() * (16.0 - radiusZ - 2.0) + 1.0 + radiusZ / 2.0;
                    for (int x2 = 1; x2 < 15; ++x2) {
                        for (int z = 1; z < 15; ++z) {
                            for (int y2 = 1; y2 < 7; ++y2) {
                                double distX = ((double)x2 - centerX) / (radiusX / 2.0);
                                double distY = ((double)y2 - centerY) / (radiusY / 2.0);
                                double distZ = ((double)z - centerZ) / (radiusZ / 2.0);
                                double dist = distX * distX + distY * distY + distZ * distZ;
                                if (!(dist < 1.0)) continue;
                                positions[(x2 * 16 + z) * 8 + y2] = true;
                            }
                        }
                    }
                }
                for (x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (y = 0; y < 8; ++y) {
                            boolean shouldPlace;
                            boolean bl = shouldPlace = !positions[(x * 16 + z) * 8 + y] && (x < 15 && positions[((x + 1) * 16 + z) * 8 + y] || x > 0 && positions[((x - 1) * 16 + z) * 8 + y] || z < 15 && positions[(x * 16 + z + 1) * 8 + y] || z > 0 && positions[(x * 16 + (z - 1)) * 8 + y] || y < 7 && positions[(x * 16 + z) * 8 + y + 1] || y > 0 && positions[(x * 16 + z) * 8 + (y - 1)]);
                            if (!shouldPlace) continue;
                            Material material = world.func_180495_p(basePos.func_177982_a(x, y, z)).func_185904_a();
                            if (y >= 4 && material.func_76224_d()) {
                                return false;
                            }
                            if (y >= 4 || material.func_76220_a() || world.func_180495_p(basePos.func_177982_a(x, y, z)) == config.field_227270_a_) continue;
                            return false;
                        }
                    }
                }
                for (x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (y = 0; y < 8; ++y) {
                            if (!positions[(x * 16 + z) * 8 + y]) continue;
                            world.func_180501_a(basePos.func_177982_a(x, y, z), y >= 4 ? Blocks.field_150350_a.func_176223_P() : config.field_227270_a_, 2);
                        }
                    }
                }
                for (x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (y = 4; y < 8; ++y) {
                            BlockPos grassPos;
                            if (!positions[(x * 16 + z) * 8 + y] || !BiomeFriendlyLakeFeature.func_227250_b_((Block)world.func_180495_p(grassPos = basePos.func_177982_a(x, y - 1, z)).func_177230_c()) || world.func_226658_a_(LightType.SKY, basePos.func_177982_a(x, y, z)) <= 0) continue;
                            Biome biome = world.func_226691_t_(grassPos);
                            world.func_180501_a(grassPos, biome.func_203944_q().func_204108_a(), 2);
                        }
                    }
                }
                if (config.field_227270_a_.func_185904_a() != Material.field_151587_i) break block22;
                for (x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (y = 0; y < 8; ++y) {
                            boolean shouldPlace;
                            boolean bl = shouldPlace = !positions[(x * 16 + z) * 8 + y] && (x < 15 && positions[((x + 1) * 16 + z) * 8 + y] || x > 0 && positions[((x - 1) * 16 + z) * 8 + y] || z < 15 && positions[(x * 16 + z + 1) * 8 + y] || z > 0 && positions[(x * 16 + (z - 1)) * 8 + y] || y < 7 && positions[(x * 16 + z) * 8 + y + 1] || y > 0 && positions[(x * 16 + z) * 8 + (y - 1)]);
                            if (!shouldPlace || y >= 4 && !rand.nextBoolean() || !world.func_180495_p(basePos.func_177982_a(x, y, z)).func_185904_a().func_76220_a()) continue;
                            world.func_180501_a(basePos.func_177982_a(x, y, z), Blocks.field_150348_b.func_176223_P(), 2);
                        }
                    }
                }
                break block23;
            }
            if (config.field_227270_a_.func_185904_a() != Material.field_151586_h) break block23;
            for (x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos icePos = basePos.func_177982_a(x, 4, z);
                    if (!world.func_226691_t_(icePos).func_201854_a((IWorldReader)world, icePos, false)) continue;
                    world.func_180501_a(icePos, Blocks.field_150432_aD.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

