/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.structures;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.command.StructureCommand;
import net.tslat.aoa3.worldgen.WorldGenerator;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public abstract class AoAStructure
extends WorldGenerator {
    private final String name;
    private boolean isWorldGen = true;

    public AoAStructure(String name) {
        this.name = name;
        StructuresHandler.registerStructure(this);
    }

    private AoAStructure() {
        this.name = "EMPTY";
    }

    public final String getName() {
        return this.name;
    }

    protected boolean replacesBlocks() {
        return false;
    }

    public boolean doPreChecks(IWorld world, Random rand, BlockPos basePos, BlockState ... groundBlocks) {
        return true;
    }

    @Override
    public final boolean generate(IWorld world, Random rand, BlockPos position) {
        boolean bl = this.isWorldGen = rand != null;
        if (rand == null) {
            rand = new Random();
        }
        if (StructureCommand.isConverting) {
            rand = new Random(){

                @Override
                public boolean nextBoolean() {
                    return true;
                }

                @Override
                public int nextInt(int val) {
                    return 0;
                }
            };
        }
        this.build(world, rand, (BlockPos)new BlockPos.Mutable(position));
        this.doPostBuildOps(world, rand, position);
        this.spawnEntities(world, rand, position);
        return true;
    }

    protected abstract void build(IWorld var1, Random var2, BlockPos var3);

    protected void doPostBuildOps(IWorld world, Random rand, BlockPos basePos) {
    }

    protected void spawnEntities(IWorld world, Random rand, BlockPos basePos) {
    }

    public final void addBlock(IWorld world, BlockPos pos, int xCoordOffset, int yCoordOffset, int zCoordOffset, BlockState block) {
        if (StructureCommand.isConverting) {
            StructureCommand.conversionStateConsumer.accept(block, new BlockPos(xCoordOffset, yCoordOffset, zCoordOffset));
            return;
        }
        if (this.replacesBlocks() || world.func_175623_d(pos.func_177982_a(xCoordOffset, yCoordOffset, zCoordOffset))) {
            world.func_180501_a(pos.func_177982_a(xCoordOffset, yCoordOffset, zCoordOffset), block, this.isWorldGen ? 2 : 3);
        }
    }

    protected void initSpawner(IWorld world, BlockPos pos, EntityType<?> entityType) {
        if (StructureCommand.isConverting) {
            StructureCommand.conversionSpawnerConsumer.accept(entityType, pos);
            return;
        }
        TileEntity spawnerTileEntity = world.func_175625_s(pos);
        if (spawnerTileEntity instanceof MobSpawnerTileEntity) {
            ((MobSpawnerTileEntity)spawnerTileEntity).func_145881_a().func_200876_a(entityType);
        }
    }

    protected void assignLootChests(IWorld world, Random rand, ResourceLocation lootTable, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            if (StructureCommand.isConverting) {
                StructureCommand.conversionChestConsumer.accept(lootTable, pos);
                continue;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof ChestTileEntity)) continue;
            ((ChestTileEntity)tileEntity).func_189404_a(lootTable, rand.nextLong());
        }
    }

    static final class EmptyStructure
    extends AoAStructure {
        EmptyStructure() {
        }

        @Override
        protected void build(IWorld world, Random rand, BlockPos basePos) {
        }
    }
}

