/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class OceanlessSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public OceanlessSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> configFactory) {
        super(configFactory);
    }

    public void buildSurface(Random rand, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState fillerBlock, BlockState fillerFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockState surfaceBlock = config.func_204108_a();
        BlockState subSurfaceBlock = config.func_204109_b();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        int height = (int)(noise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int subSurfaceBlockLayers = -1;
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        for (int y = startHeight; y >= 0; --y) {
            mutablePos.func_181079_c(chunkX, y, chunkZ);
            BlockState yBlock = chunk.func_180495_p((BlockPos)mutablePos);
            if (yBlock.func_196958_f()) {
                subSurfaceBlockLayers = -1;
                continue;
            }
            if (yBlock.func_177230_c() != fillerBlock.func_177230_c()) continue;
            if (subSurfaceBlockLayers == -1) {
                if (height <= 0) {
                    surfaceBlock = Blocks.field_150350_a.func_176223_P();
                    subSurfaceBlock = fillerBlock;
                }
                chunk.func_177436_a((BlockPos)mutablePos, surfaceBlock, false);
                subSurfaceBlockLayers = height;
                continue;
            }
            if (subSurfaceBlockLayers <= 0) continue;
            --subSurfaceBlockLayers;
            chunk.func_177436_a((BlockPos)mutablePos, subSurfaceBlock, false);
        }
    }
}

