/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.surfacebuilder.config;

import com.mojang.datafixers.Dynamic;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Tuple;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class TieredSurfaceBuilderConfig
implements ISurfaceBuilderConfig {
    private final BlockState surfaceBlock;
    private final BlockState subsurfaceBlock;
    private final Tuple<BlockState, Integer>[] blockLayers;

    public TieredSurfaceBuilderConfig(BlockState surfaceBlock, BlockState subsurfaceBlock, Tuple<BlockState, Integer> ... blockLayers) {
        this.surfaceBlock = surfaceBlock;
        this.subsurfaceBlock = subsurfaceBlock;
        this.blockLayers = blockLayers;
    }

    public BlockState func_204108_a() {
        return this.surfaceBlock;
    }

    public BlockState func_204109_b() {
        return this.subsurfaceBlock;
    }

    public BlockState getBlockForLayer(int yPos) {
        for (Tuple<BlockState, Integer> layer : this.blockLayers) {
            if (yPos >= (Integer)layer.func_76340_b()) continue;
            return (BlockState)layer.func_76341_a();
        }
        return (BlockState)this.blockLayers[0].func_76341_a();
    }

    public static TieredSurfaceBuilderConfig deserialize(Dynamic<?> data) {
        BlockState surfaceBlock = data.get("surface_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        BlockState subsurfaceBlock = data.get("subsurface_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        return new TieredSurfaceBuilderConfig(surfaceBlock, subsurfaceBlock, new Tuple((Object)subsurfaceBlock, (Object)256));
    }
}

