/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class BloodtwisterTreeGenerator
extends TreeGenerator {
    public BloodtwisterTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int weaveHeight;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (weaveHeight = 8 + rand.nextInt(8)), 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.BLOOD_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.BLOOD_LEAVES.get()).func_176223_P();
        BlockState barkLog = ((Block)AoABlocks.BLOOD_WOOD.get()).func_176223_P();
        this.placeBlock(world, pos.func_177981_b(1 + rand.nextInt(3)), ((Block)AoABlocks.EYEBALL_LOG.get()).func_176223_P());
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        this.placeBlock(world, movablePos.func_177982_a(1, 0, 0), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 1), barkLog);
        this.placeBlock(world, (BlockPos)movablePos, barkLog);
        this.placeBlock(world, movablePos.func_177982_a(-1, 0, 0), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -1), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(2, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 2), leaves);
        this.placeBlock(world, movablePos.func_177982_a(-2, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -2), leaves);
        this.placeBlock(world, movablePos.func_177982_a(3, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 3), leaves);
        this.placeBlock(world, movablePos.func_177982_a(-3, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -3), leaves);
        if (rand.nextBoolean()) {
            Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.func_185334_h();
            movablePos.func_189534_c(Direction.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(directions[direction]), leaves);
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.func_189533_g((Vec3i)basePos).func_189534_c(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        } else {
            Direction[] directions = new Direction[]{Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.func_185334_h();
            movablePos.func_189534_c(Direction.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(directions[direction]), leaves);
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.func_189533_g((Vec3i)basePos).func_189534_c(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        }
        return true;
    }
}

