/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.block.generation.plants.VinesBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class CreepTreeGenerator
extends TreeGenerator {
    private static final BlockState leaves = ((Block)AoABlocks.CREEP_LEAVES.get()).func_176223_P();
    private static final BlockState vines = ((Block)AoABlocks.CREEP_VINES.get()).func_176223_P();
    private final ArrayList<BlockPos> leafPositions = new ArrayList();

    public CreepTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 6 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.CREEP_LOG.get()).func_176223_P();
        int ringLocation = 1 + rand.nextInt(trunkHeight - 3);
        if (ringLocation < trunkHeight / 2) {
            ringLocation = -1;
        }
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
            if (i != ringLocation) continue;
            int ringWidth = 1 + rand.nextInt(2);
            for (int y = 0; y <= rand.nextInt(2); ++y) {
                for (int x = -ringWidth; x <= ringWidth; ++x) {
                    for (int z = -ringWidth; z <= ringWidth; ++z) {
                        this.placeLeafBlock(world, movablePos.func_177982_a(x, y, z));
                    }
                }
            }
        }
        if (rand.nextBoolean()) {
            int width = 1 + rand.nextInt(2);
            for (int y = 0; y <= 1 + rand.nextInt(2); ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        this.placeLeafBlock(world, movablePos.func_177982_a(x, y, z));
                    }
                }
            }
        } else {
            int z;
            int x;
            for (int y = 0; y > -rand.nextInt(3); --y) {
                for (int x2 = -2; x2 <= 2; ++x2) {
                    for (int z2 = -2; z2 <= 2; ++z2) {
                        this.placeLeafBlock(world, movablePos.func_177982_a(x2, y, z2));
                    }
                }
            }
            if (rand.nextBoolean()) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (x * x + z * z > 4) continue;
                        this.placeLeafBlock(world, movablePos.func_177982_a(x, 1, z));
                    }
                }
            } else {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        this.placeLeafBlock(world, movablePos.func_177982_a(x, 1, z));
                    }
                }
            }
        }
        this.populateVines(world, rand);
        return true;
    }

    private void placeLeafBlock(IWorld world, BlockPos leafPos) {
        this.placeBlock(world, leafPos, leaves);
        this.leafPositions.add(leafPos);
    }

    private void populateVines(IWorld world, Random rand) {
        for (BlockPos pos : this.leafPositions) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos vinePos;
                if (!(rand.nextFloat() < 0.65f) || !world.func_175623_d(vinePos = pos.func_177972_a(dir))) continue;
                BlockState state = ((VinesBlock)vines.func_177230_c()).getStateForPosition(world, vinePos);
                this.placeBlock(world, vinePos, state);
                for (int count = 0; count < 2 && rand.nextFloat() < 0.65f && world.func_175623_d(vinePos = vinePos.func_177977_b()); ++count) {
                    state = ((VinesBlock)vines.func_177230_c()).getStateForPosition(world, vinePos);
                    this.placeBlock(world, vinePos, state);
                }
            }
        }
    }
}

