/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class DawnwoodTreeGenerator
extends TreeGenerator {
    public DawnwoodTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 15 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.DAWN_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.DAWN_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177978_c(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177968_d(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177974_f(), leaves);
            }
            if (rand.nextInt(4) != 0) continue;
            this.placeBlock(world, movablePos.func_177976_e(), leaves);
        }
        if (rand.nextInt(3) == 0) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, -1, z), leaves);
                    this.placeBlock(world, movablePos.func_177982_a(x, 1, z), leaves);
                }
            }
            int leafWidth = 2 + rand.nextInt(2);
            for (int x = -leafWidth; x <= leafWidth; ++x) {
                for (int z = -leafWidth; z <= leafWidth; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, 0, z), leaves);
                }
            }
            this.placeBlock(world, movablePos.func_177982_a(0, 2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, -2, -1), leaves);
        } else if (rand.nextBoolean()) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), leaves);
        }
        return true;
    }
}

