/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class EyeHangerTreeGenerator
extends TreeGenerator {
    public EyeHangerTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int i;
        int weaveHeight;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (weaveHeight = 8 + rand.nextInt(8)), 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.SHADOW_LOG.get()).func_176223_P();
        BlockState barkLog = ((Block)AoABlocks.SHADOW_WOOD.get()).func_176223_P();
        int branchWidth = 1 + rand.nextInt(3);
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        for (i = 1; i <= branchWidth; ++i) {
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(-i, 0, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, -i), barkLog);
            if (i != branchWidth || !rand.nextBoolean()) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 1, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(-i, 1, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 1, i), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 1, -i), log);
        }
        this.doLeaves(world, movablePos.func_177984_a(), rand, branchWidth);
        return true;
    }

    private void doLeaves(IWorld world, BlockPos pos, Random rand, int branchWidth) {
        int j;
        int i;
        BlockState leaves = ((Block)AoABlocks.SHADOWBLOOD_LEAVES.get()).func_176223_P();
        for (i = -branchWidth - 1; i <= branchWidth + 1; ++i) {
            this.placeBlock(world, pos.func_177982_a(-i, 0, 0), leaves);
            if (Math.abs(i) > branchWidth && rand.nextInt(7) == 0) {
                this.doEyeHanger(world, pos.func_177982_a(i, 0, 0), rand);
            }
            for (j = 0; j <= branchWidth; ++j) {
                if (Math.abs(i) > branchWidth - j + 1) continue;
                this.placeBlock(world, pos.func_177982_a(i, 0, j + 1), leaves);
                this.placeBlock(world, pos.func_177982_a(-i, 0, -j - 1), leaves);
                if (i == 0) continue;
                if (rand.nextInt(7) == 0) {
                    this.doEyeHanger(world, pos.func_177982_a(i, 0, -j - 1), rand);
                }
                if (rand.nextInt(7) != 0) continue;
                this.doEyeHanger(world, pos.func_177982_a(i, 0, j + 1), rand);
            }
        }
        for (i = -branchWidth; i <= branchWidth; ++i) {
            for (j = 0; j <= branchWidth - Math.abs(i); ++j) {
                this.placeBlock(world, pos.func_177982_a(i, 1, j), leaves);
                this.placeBlock(world, pos.func_177982_a(i, 1, -j), leaves);
            }
        }
        if (branchWidth == 3) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, 2, z), leaves);
                }
            }
        }
    }

    private void doEyeHanger(IWorld world, BlockPos leafPos, Random rand) {
        BlockState bloodStrands = ((Block)AoABlocks.BLOOD_STRANDS.get()).func_176223_P();
        BlockState eye = ((Block)AoABlocks.EYE_BLOCK.get()).func_176223_P();
        int length = 2 + rand.nextInt(3);
        for (int i = 1; i <= length; ++i) {
            this.placeBlock(world, leafPos.func_177979_c(i), bloodStrands);
        }
        this.placeBlock(world, leafPos.func_177979_c(length + 1), eye);
    }
}

