/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class EyebushTreeGenerator
extends TreeGenerator {
    public EyebushTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        boolean doubleTrunk = rand.nextBoolean();
        if (!this.checkSafeHeight(world, pos, (doubleTrunk ? 2 : 1) + 5, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockState log = ((Block)AoABlocks.EYEBALL_LOG.get()).func_176223_P();
        this.placeBlock(world, pos, log);
        pos = pos.func_177984_a();
        if (doubleTrunk) {
            this.placeBlock(world, pos, log);
            pos = pos.func_177984_a();
        }
        this.placeBlock(world, pos.func_177978_c(), log);
        this.placeBlock(world, pos.func_177968_d(), log);
        this.placeBlock(world, pos.func_177974_f(), log);
        this.placeBlock(world, pos.func_177976_e(), log);
        this.placeBlock(world, pos.func_177984_a(), log);
        this.placeBlock(world, pos.func_177981_b(2), log);
        this.buildLeafRing(world, pos, 2);
        this.buildLeafRing(world, pos.func_177984_a(), 3);
        this.buildLeafRing(world, pos.func_177981_b(2), 2);
        this.buildLeafRing(world, pos.func_177981_b(3), 1);
        this.placeBlock(world, pos.func_177981_b(4), ((Block)AoABlocks.VEIN_LEAVES.get()).func_176223_P());
        return true;
    }

    private void buildLeafRing(IWorld world, BlockPos pos, int radius) {
        BlockState leaves = ((Block)AoABlocks.VEIN_LEAVES.get()).func_176223_P();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((x == radius || x == -radius) && (z == radius || z == -radius)) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), leaves);
            }
        }
    }
}

