/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class HauntedTreeGenerator
extends TreeGenerator {
    private final int hauntedLeafChance = 80;
    private final int hauntedLogChance = 25;
    private final int purplingLogChance = 20;

    public HauntedTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        switch (rand.nextInt(4)) {
            case 0: {
                return this.generateTree1(world, rand, pos);
            }
            case 1: {
                return this.generateTree2(world, rand, pos);
            }
            case 2: {
                return this.generateTree3(world, rand, pos);
            }
            case 3: {
                return this.generateTree4(world, rand, pos);
            }
        }
        return true;
    }

    private boolean generateTree1(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 24;
        if (!this.checkSafeHeight(world, pos, trunkHeight + 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = rand.nextInt(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).func_176223_P() : ((Block)AoABlocks.HAUNTED_LOG.get()).func_176223_P();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).func_176223_P();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).func_176223_P();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            BlockState logBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), logBlock);
        }
        this.generateCrossBranch(world, rand, pos.func_177981_b(5), log, 6);
        this.generateCrossBranch(world, rand, pos.func_177981_b(10), log, 5);
        this.generateCrossBranch(world, rand, pos.func_177981_b(15), log, 4);
        this.generateCrossBranch(world, rand, pos.func_177981_b(19), log, 3);
        this.generateCrossBranch(world, rand, pos.func_177981_b(23), log, 2);
        this.placeBlock(world, pos.func_177982_a(0, 24, 0), rand.nextInt(80) == 0 ? eyeLeaves : leaves);
        return true;
    }

    private boolean generateTree2(IWorld world, Random rand, BlockPos pos) {
        BlockState leafBlock;
        int z;
        int x;
        int i;
        int trunkHeight = 12 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = rand.nextInt(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).func_176223_P() : ((Block)AoABlocks.HAUNTED_LOG.get()).func_176223_P();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).func_176223_P();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).func_176223_P();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).func_176223_P();
        for (int i2 = 0; i2 < trunkHeight; ++i2) {
            BlockState logBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), logBlock);
        }
        int coreHeight = 3 + rand.nextInt(3);
        int bottomCoreHeight = 3 + rand.nextInt(3);
        for (i = 0; i < coreHeight; ++i) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(world, movablePos.func_177982_a(x, -i, z), leafBlock);
                }
            }
        }
        for (i = 0; i < bottomCoreHeight; ++i) {
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(world, movablePos.func_177982_a(x, -coreHeight + -i, z), leafBlock);
                }
            }
        }
        for (i = -3; i <= 3; i += 6) {
            for (int j = -1; j <= 1; j += 2) {
                int y;
                for (y = 0; y <= 2 + rand.nextInt(3); ++y) {
                    leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(world, movablePos.func_177982_a(i, -coreHeight + y, j), leafBlock);
                }
                for (y = 0; y <= 2 + rand.nextInt(3); ++y) {
                    leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(world, movablePos.func_177982_a(j, -coreHeight + y, i), leafBlock);
                }
            }
        }
        for (i = 1; i <= 1 + rand.nextInt(3); ++i) {
            BlockState leafBlock2 = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
            this.placeBlock(world, movablePos.func_177982_a(0, i, 0), leafBlock2);
        }
        return true;
    }

    private boolean generateTree3(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 10 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        boolean purpling = rand.nextInt(20) == 0;
        BlockState log = purpling ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).func_176223_P() : ((Block)AoABlocks.HAUNTED_LOG.get()).func_176223_P();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).func_176223_P();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).func_176223_P();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).func_176223_P();
        HashMap<Direction, Integer> branchOffsetMap = new HashMap<Direction, Integer>(4);
        for (int i = 0; i < trunkHeight; ++i) {
            BlockState logBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), logBlock);
            if (i <= 3) continue;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (branchOffsetMap.containsKey(dir) && i - (Integer)branchOffsetMap.get(dir) <= 3 || rand.nextInt(3) != 0) continue;
                branchOffsetMap.put(dir, i);
                for (int j = 1; j <= 4; ++j) {
                    BlockPos branchLocPos = movablePos.func_177967_a(dir, j);
                    BlockState branchLogBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
                    BlockState barkBlock = this.getBarkForLog(branchLogBlock);
                    this.placeBlock(world, branchLocPos, barkBlock);
                    if (j <= 1) continue;
                    if (j == 2 || j == 4) {
                        BlockState branchLogBlock2 = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
                        this.placeBlock(world, branchLocPos.func_177977_b(), branchLogBlock2);
                    }
                    Direction sidewaysDir = dir.func_176735_f();
                    branchLocPos = branchLocPos.func_177979_c(2);
                    for (int k = -1; k <= 1; ++k) {
                        BlockState leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                        this.placeBlock(world, branchLocPos.func_177967_a(sidewaysDir, k), leafBlock);
                    }
                }
            }
        }
        return true;
    }

    private boolean generateTree4(IWorld world, Random rand, BlockPos pos) {
        BlockState logBlock;
        int i;
        int trunkHeight = 7 + rand.nextInt(7);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 3, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = rand.nextInt(20) == 0 ? ((Block)AoABlocks.HAUNTED_PURPLING_LOG.get()).func_176223_P() : ((Block)AoABlocks.HAUNTED_LOG.get()).func_176223_P();
        BlockState redEyesLog = ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).func_176223_P();
        BlockState eyeLog = ((Block)AoABlocks.HAUNTED_EYE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).func_176223_P();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            logBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), logBlock);
        }
        for (i = -2; i <= 2; ++i) {
            BlockState logBlock3;
            BlockState blockState = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : (logBlock = log);
            BlockState logBlock2 = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            BlockState barkBlock = this.getBarkForLog(logBlock);
            BlockState barkBlock2 = this.getBarkForLog(logBlock2);
            this.placeBlock(world, movablePos.func_177982_a(i, 1, 0), barkBlock);
            this.placeBlock(world, movablePos.func_177982_a(0, 1, i), barkBlock2);
            if (Math.abs(i) != 2) continue;
            BlockState blockState2 = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : (logBlock3 = log);
            BlockState logBlock4 = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeLog : redEyesLog) : log;
            this.placeBlock(world, movablePos.func_177982_a(i, 2, 0), logBlock3);
            this.placeBlock(world, movablePos.func_177982_a(0, 2, i), logBlock4);
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (x * x + z * z > 16 - (3 - Math.abs(x) - Math.abs(z))) continue;
                BlockState leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                BlockPos leafPos = movablePos.func_177982_a(x, 3, z);
                this.placeBlock(world, leafPos, leafBlock);
                if (Math.abs(x) <= 2 && Math.abs(z) <= 2 || rand.nextInt(5) != 0) continue;
                for (int i2 = 1; i2 <= 3 + rand.nextInt(3); ++i2) {
                    BlockState leafBlock2 = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    this.placeBlock(world, leafPos.func_177982_a(0, -i2, 0), leafBlock2);
                }
            }
        }
        return true;
    }

    private void generateCrossBranch(IWorld world, Random rand, BlockPos branchPos, BlockState log, int length) {
        BlockState barkLog = this.getBarkForLog(log);
        BlockState redEyesBarkLog = ((Block)AoABlocks.HAUNTED_EYES_WOOD.get()).func_176223_P();
        BlockState eyeBarkLog = ((Block)AoABlocks.HAUNTED_EYE_WOOD.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.HAUNTED_LEAVES.get()).func_176223_P();
        BlockState eyeLeaves = ((Block)AoABlocks.HAUNTED_EYES_LEAVES.get()).func_176223_P();
        for (int i = 1; i <= length; ++i) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState logBlock = rand.nextInt(25) == 0 ? (rand.nextBoolean() ? eyeBarkLog : redEyesBarkLog) : barkLog;
                BlockPos branchLocPos = branchPos.func_177967_a(dir, i);
                this.placeBlock(world, branchPos.func_177967_a(dir, i), logBlock);
                for (Direction leafDir : Direction.values()) {
                    BlockState leafBlock;
                    BlockState blockState = leafBlock = rand.nextInt(80) == 0 ? eyeLeaves : leaves;
                    if (leafDir == Direction.DOWN) continue;
                    this.placeBlock(world, branchLocPos.func_177972_a(leafDir), leafBlock);
                }
            }
        }
    }

    private BlockState getBarkForLog(BlockState state) {
        if (state.func_177230_c() == AoABlocks.HAUNTED_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_WOOD.get()).func_176223_P();
        }
        if (state.func_177230_c() == AoABlocks.HAUNTED_PURPLING_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_PURPLING_WOOD.get()).func_176223_P();
        }
        if (state.func_177230_c() == AoABlocks.HAUNTED_EYE_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_EYES_LOG.get()).func_176223_P();
        }
        if (state.func_177230_c() == AoABlocks.HAUNTED_EYES_LOG.get()) {
            return ((Block)AoABlocks.HAUNTED_EYES_WOOD.get()).func_176223_P();
        }
        return ((Block)AoABlocks.HAUNTED_WOOD.get()).func_176223_P();
    }
}

