/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class HavenTreeGenerator
extends TreeGenerator {
    private final BlockState leavesBlock;

    public HavenTreeGenerator(@Nullable SaplingBlock sapling, @Nullable LeavesBlock leaves, Random rand) {
        super(sapling);
        if (leaves == null) {
            switch (rand.nextInt(6)) {
                case 0: {
                    this.leavesBlock = ((Block)AoABlocks.BLUE_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
                case 1: {
                    this.leavesBlock = ((Block)AoABlocks.PINK_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
                case 2: {
                    this.leavesBlock = ((Block)AoABlocks.PURPLE_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
                case 3: {
                    this.leavesBlock = ((Block)AoABlocks.RED_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
                case 4: {
                    this.leavesBlock = ((Block)AoABlocks.TURQUOISE_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
                default: {
                    this.leavesBlock = ((Block)AoABlocks.YELLOW_HAVEN_LEAVES.get()).func_176223_P();
                    break;
                }
            }
        } else {
            this.leavesBlock = leaves.func_176223_P();
        }
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(world, rand, pos, 2);
        switch (rand.nextInt(3) + (multiSaplingPos == null ? 0 : 3)) {
            case 0: {
                return this.generateTree1(world, rand, pos);
            }
            case 1: {
                return this.generateTree2(world, rand, pos);
            }
            case 2: {
                return this.generateTree3(world, rand, pos);
            }
            case 3: {
                return this.generateTree4(world, rand, multiSaplingPos);
            }
            case 4: {
                return this.generateTree5(world, rand, multiSaplingPos);
            }
            case 5: {
                return this.generateTree6(world, rand, multiSaplingPos);
            }
        }
        return false;
    }

    private boolean generateTree1(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 10 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = Blocks.field_196617_K.func_176223_P();
        boolean builtLeafRing = false;
        for (int i = 0; i < trunkHeight; ++i) {
            int z;
            int x;
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
            if (builtLeafRing || i <= 1 || i < trunkHeight - 4 && rand.nextInt(3) != 0) continue;
            BlockPos leafPosBase = movablePos.func_185334_h();
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.NORTH), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.EAST), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.SOUTH), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.WEST), this.leavesBlock);
            leafPosBase = leafPosBase.func_177984_a();
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if (Math.abs(x * z) >= 2) continue;
                    this.placeBlock(world, leafPosBase.func_177982_a(x, 0, z), this.leavesBlock);
                }
            }
            if (rand.nextBoolean()) {
                leafPosBase = leafPosBase.func_177984_a();
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (Math.abs(x * z) >= 2) continue;
                        this.placeBlock(world, leafPosBase.func_177982_a(x, 0, z), this.leavesBlock);
                    }
                }
            }
            leafPosBase = leafPosBase.func_177984_a();
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.NORTH), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.EAST), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.SOUTH), this.leavesBlock);
            this.placeBlock(world, leafPosBase.func_177972_a(Direction.WEST), this.leavesBlock);
            builtLeafRing = true;
        }
        this.placeBlock(world, movablePos.func_177982_a(1, -2, 0), this.leavesBlock);
        this.placeBlock(world, movablePos.func_177982_a(0, -2, 1), this.leavesBlock);
        this.placeBlock(world, movablePos.func_177982_a(0, -2, -1), this.leavesBlock);
        this.placeBlock(world, movablePos.func_177982_a(-1, -2, 0), this.leavesBlock);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.placeBlock(world, movablePos.func_177982_a(x, -1, z), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(x, 1, z), this.leavesBlock);
            }
        }
        boolean cornerLeaves = rand.nextBoolean();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (!cornerLeaves && Math.abs(x * z) == 4) continue;
                this.placeBlock(world, movablePos.func_177982_a(x, 0, z), this.leavesBlock);
            }
        }
        this.placeBlock(world, movablePos.func_177982_a(0, 2, 0), this.leavesBlock);
        return true;
    }

    private boolean generateTree2(IWorld world, Random rand, BlockPos pos) {
        int y;
        int trunkHeight = 7 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = Blocks.field_196617_K.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        movablePos.func_189536_c(Direction.DOWN);
        for (int x = -3; x <= 3; ++x) {
            for (y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    int z2;
                    int y2;
                    int x2 = Math.abs(x);
                    int max = Math.max(x2, Math.max(y2 = Math.abs(y), z2 = Math.abs(z)));
                    if (!(max == 3 && x2 + y2 + z2 == 3 || max == 2 && x2 + y2 + z2 < 4) && max != 1) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), this.leavesBlock);
                }
            }
        }
        int leafDrop = 2 + rand.nextInt(3);
        for (y = 1; y <= leafDrop; ++y) {
            this.placeBlock(world, movablePos.func_177982_a(3, -y, 0), this.leavesBlock);
            this.placeBlock(world, movablePos.func_177982_a(-3, -y, 0), this.leavesBlock);
            this.placeBlock(world, movablePos.func_177982_a(0, -y, 3), this.leavesBlock);
            this.placeBlock(world, movablePos.func_177982_a(0, -y, -3), this.leavesBlock);
        }
        return true;
    }

    private boolean generateTree3(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 5 + rand.nextInt(4);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 8, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = Blocks.field_196617_K.func_176223_P();
        BlockState barkLog = Blocks.field_196626_Q.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        this.placeBlock(world, (BlockPos)movablePos, barkLog);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int y;
            int x;
            BlockPos.Mutable branchMovablePos = new BlockPos.Mutable((BlockPos)movablePos);
            ArrayList<Direction> availableDirections = new ArrayList<Direction>(5);
            for (Direction dir : Direction.values()) {
                if (dir == direction) continue;
                availableDirections.add(dir);
            }
            this.placeBlock(world, (BlockPos)branchMovablePos.func_189536_c(direction), barkLog);
            Direction branchDir = direction;
            for (int i = 0; i <= 3; ++i) {
                branchDir = rand.nextBoolean() ? (Direction)availableDirections.get(rand.nextInt(5)) : branchDir;
                availableDirections.clear();
                for (Direction dir : Direction.values()) {
                    if (dir == branchDir) continue;
                    availableDirections.add(dir);
                }
                this.placeBlock(world, (BlockPos)branchMovablePos.func_189536_c(branchDir), barkLog);
            }
            this.placeBlock(world, branchMovablePos.func_177982_a(0, 1, 0), log);
            this.placeBlock(world, branchMovablePos.func_177982_a(0, 2, 0), log);
            if (rand.nextBoolean()) {
                for (x = -1; x <= 1; ++x) {
                    for (y = 1; y <= 4; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(world, branchMovablePos.func_177982_a(x, y, z), this.leavesBlock);
                        }
                    }
                }
                this.placeBlock(world, branchMovablePos.func_177982_a(0, 5, 0), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(2, 2, 0), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(-2, 2, 0), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(0, 2, 2), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(0, 2, -2), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(2, 3, 0), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(-2, 3, 0), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(0, 3, 2), this.leavesBlock);
                this.placeBlock(world, branchMovablePos.func_177982_a(0, 3, -2), this.leavesBlock);
                continue;
            }
            for (x = -1; x <= 1; ++x) {
                for (y = 1; y <= 3; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        this.placeBlock(world, branchMovablePos.func_177982_a(x, y, z), this.leavesBlock);
                    }
                }
            }
            this.placeBlock(world, branchMovablePos.func_177982_a(0, 4, 0), this.leavesBlock);
            this.placeBlock(world, branchMovablePos.func_177982_a(2, 2, 0), this.leavesBlock);
            this.placeBlock(world, branchMovablePos.func_177982_a(-2, 2, 0), this.leavesBlock);
            this.placeBlock(world, branchMovablePos.func_177982_a(0, 2, 2), this.leavesBlock);
            this.placeBlock(world, branchMovablePos.func_177982_a(0, 2, -2), this.leavesBlock);
        }
        return true;
    }

    private boolean generateTree4(IWorld world, Random rand, BlockPos pos) {
        int z;
        int x;
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 4, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        BlockState log = Blocks.field_196617_K.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            for (x = 0; x <= 1; ++x) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, i, z), log);
                }
            }
        }
        pos = pos.func_177981_b(trunkHeight - 3);
        boolean thickBranch = rand.nextBoolean();
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if ((z == -1 || z == 2) && (x == -1 || x == 2)) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), log);
                if (!thickBranch) continue;
                this.placeBlock(world, pos.func_177982_a(x, 1, z), log);
            }
        }
        this.placeBlock(world, pos.func_177982_a(-2, 1, 0), log);
        this.placeBlock(world, pos.func_177982_a(-2, 1, 1), log);
        this.placeBlock(world, pos.func_177982_a(0, 1, -2), log);
        this.placeBlock(world, pos.func_177982_a(1, 1, -2), log);
        this.placeBlock(world, pos.func_177982_a(0, 1, 3), log);
        this.placeBlock(world, pos.func_177982_a(1, 1, 3), log);
        this.placeBlock(world, pos.func_177982_a(3, 1, 0), log);
        this.placeBlock(world, pos.func_177982_a(3, 1, 1), log);
        for (x = -3; x <= 4; ++x) {
            for (z = -3; z <= 4; ++z) {
                if ((x < -1 || x > 2) && (z < -1 || z > 2)) continue;
                this.placeBlock(world, pos.func_177982_a(x, 1, z), this.leavesBlock);
                if ((x == 0 || x == 1) && z > -3 && z <= 3 || (z == 0 || z == 1) && x > -3 && x <= 3) continue;
                int x2 = x;
                int z2 = z;
                x2 = x <= 0 ? --x2 : ++x2;
                z2 = z <= 0 ? --z2 : ++z2;
                this.placeBlock(world, pos.func_177982_a(x2, 0, z2), this.leavesBlock);
            }
        }
        this.placeBlock(world, pos.func_177982_a(-4, 0, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(-4, 0, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(5, 0, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(5, 0, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(0, 0, -4), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 0, -4), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(0, 0, 5), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 0, 5), this.leavesBlock);
        for (x = 0; x <= 1; ++x) {
            for (z = -2; z <= 3; ++z) {
                this.placeBlock(world, pos.func_177982_a(x, 2, z), this.leavesBlock);
            }
        }
        this.placeBlock(world, pos.func_177982_a(-2, 2, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(-1, 2, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(-2, 2, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(-1, 2, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(3, 2, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(2, 2, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(3, 2, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(2, 2, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(0, 3, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(0, 3, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 3, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 3, 1), this.leavesBlock);
        return true;
    }

    private boolean generateTree5(IWorld world, Random rand, BlockPos pos) {
        int z;
        int x;
        int z2;
        int trunkHeight = 20 + rand.nextInt(15);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        BlockState log = Blocks.field_196617_K.func_176223_P();
        int leafRingGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            int x2;
            for (int x3 = 0; x3 <= 1; ++x3) {
                for (int z3 = 0; z3 <= 1; ++z3) {
                    this.placeBlock(world, pos.func_177982_a(x3, i, z3), log);
                }
            }
            if (++leafRingGap <= 5 || i >= trunkHeight - 6 || rand.nextInt(5) != 0) continue;
            if (rand.nextBoolean()) {
                leafRingGap = 0;
                for (x2 = -1; x2 <= 2; ++x2) {
                    for (z2 = -1; z2 <= 2; ++z2) {
                        this.placeBlock(world, pos.func_177982_a(x2, i, z2), this.leavesBlock);
                        this.placeBlock(world, pos.func_177982_a(x2, i + 2, z2), this.leavesBlock);
                    }
                }
                for (x2 = -2; x2 <= 3; ++x2) {
                    for (z2 = -2; z2 <= 3; ++z2) {
                        this.placeBlock(world, pos.func_177982_a(x2, i + 1, z2), this.leavesBlock);
                    }
                }
                continue;
            }
            leafRingGap = -2;
            for (x2 = -1; x2 <= 2; ++x2) {
                for (z2 = -1; z2 <= 2; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x2, i, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x2, i + 4, z2), this.leavesBlock);
                }
            }
            for (x2 = -2; x2 <= 3; ++x2) {
                for (z2 = -2; z2 <= 3; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x2, i + 1, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x2, i + 3, z2), this.leavesBlock);
                }
            }
            for (x2 = -3; x2 <= 4; ++x2) {
                for (z2 = -3; z2 <= 4; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x2, i + 2, z2), this.leavesBlock);
                }
            }
        }
        pos = pos.func_177981_b(trunkHeight - 3);
        for (x = -4; x <= 5; ++x) {
            for (z = 0; z <= 1; ++z) {
                this.placeBlock(world, pos.func_177982_a(x, 0, z), this.leavesBlock);
                this.placeBlock(world, pos.func_177982_a(x, 4, z), this.leavesBlock);
                if (x != 0 && x != 1 || z != 0) continue;
                for (z2 = -4; z2 < 0; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 0, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x, 4, z2), this.leavesBlock);
                }
                for (z2 = 2; z2 < 6; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 0, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x, 4, z2), this.leavesBlock);
                }
            }
        }
        for (x = -5; x <= 6; ++x) {
            for (z = -1; z <= 2; ++z) {
                this.placeBlock(world, pos.func_177982_a(x, 1, z), this.leavesBlock);
                this.placeBlock(world, pos.func_177982_a(x, 3, z), this.leavesBlock);
                if (x < -1 || x > 2 || z != 0) continue;
                for (z2 = -5; z2 < 0; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 1, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x, 3, z2), this.leavesBlock);
                }
                for (z2 = 3; z2 < 7; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 1, z2), this.leavesBlock);
                    this.placeBlock(world, pos.func_177982_a(x, 3, z2), this.leavesBlock);
                }
            }
        }
        for (x = -6; x <= 7; ++x) {
            for (z = -2; z <= 3; ++z) {
                this.placeBlock(world, pos.func_177982_a(x, 2, z), this.leavesBlock);
                if (x < -2 || x > 3 || z != 0) continue;
                for (z2 = -6; z2 < 0; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 2, z2), this.leavesBlock);
                }
                for (z2 = 4; z2 < 8; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x, 2, z2), this.leavesBlock);
                }
            }
        }
        return true;
    }

    private boolean generateTree6(IWorld world, Random rand, BlockPos pos) {
        int z;
        int x;
        int trunkHeight = 15 + rand.nextInt(8);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 4, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        BlockState log = Blocks.field_196617_K.func_176223_P();
        int leafRingGap = -1;
        for (int i = 0; i < trunkHeight; ++i) {
            int z2;
            int x2;
            for (x = 0; x <= 1; ++x) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, i, z), log);
                }
            }
            if (++leafRingGap <= 3 || i >= trunkHeight - 7 || !rand.nextBoolean()) continue;
            leafRingGap = 0;
            int ringWidth = 2 + rand.nextInt(3);
            boolean fullTopRing = rand.nextBoolean();
            boolean fullBottomRing = rand.nextBoolean();
            for (x2 = -1; x2 <= 2; ++x2) {
                for (z2 = -1; z2 <= 2; ++z2) {
                    if (fullTopRing || x2 == 0 || x2 == 1 || z2 == 0 || z2 == 1) {
                        this.placeBlock(world, pos.func_177982_a(x2, i + 2, z2), this.leavesBlock);
                    }
                    if (!fullBottomRing && x2 != 0 && x2 != 1 && z2 != 0 && z2 != 1) continue;
                    this.placeBlock(world, pos.func_177982_a(x2, i, z2), this.leavesBlock);
                }
            }
            for (x2 = -ringWidth; x2 <= ringWidth + 1; ++x2) {
                for (z2 = -ringWidth; z2 <= ringWidth + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > ringWidth - (Math.abs(z3) - 3)) continue;
                    this.placeBlock(world, pos.func_177982_a(x2, i + 1, z2), this.leavesBlock);
                }
            }
        }
        pos = pos.func_177981_b(trunkHeight - 3);
        boolean fullRing = rand.nextBoolean();
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!fullRing && x != 0 && x != 1 && z != 0 && z != 1) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), this.leavesBlock);
            }
        }
        for (int i = 4; i > 0; --i) {
            for (int x2 = -i; x2 <= i + 1; ++x2) {
                for (int z2 = -i; z2 <= i + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > i - (Math.abs(z3) - 3)) continue;
                    this.placeBlock(world, pos.func_177982_a(x2, 5 - i, z2), this.leavesBlock);
                }
            }
        }
        this.placeBlock(world, pos.func_177982_a(0, 5, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 5, 0), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(0, 5, 1), this.leavesBlock);
        this.placeBlock(world, pos.func_177982_a(1, 5, 1), this.leavesBlock);
        return true;
    }
}

