/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class InvertedChurryTreeGenerator
extends TreeGenerator {
    public InvertedChurryTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    protected boolean checkSafeHeight(IWorld world, BlockPos pos, int maxHeight, int trunkWidth) {
        return pos.func_177956_o() <= 256 && pos.func_177956_o() - maxHeight >= 1;
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 25 + rand.nextInt(15);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 3, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177984_a());
        BlockState log = ((Block)AoABlocks.CHURRY_LOG.get()).func_176223_P();
        BlockState lelyetianLeaves = ((Block)AoABlocks.LELYETIAN_LEAVES.get()).func_176223_P();
        int leafGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.DOWN), log);
            if (i <= 6 || ++leafGap <= 6 || leafGap <= 11 && rand.nextInt(5) != 0) continue;
            leafGap = 0;
            this.buildLeafBlob(world, movablePos.func_185334_h(), rand);
        }
        this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.DOWN), log);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 3; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, -y, z), lelyetianLeaves);
                }
            }
        }
        return true;
    }

    private void buildLeafBlob(IWorld world, BlockPos pos, Random rand) {
        int x;
        BlockState leaves = ((Block)AoABlocks.CHURRY_LEAVES.get()).func_176223_P();
        this.placeBlock(world, pos.func_177978_c(), leaves);
        this.placeBlock(world, pos.func_177968_d(), leaves);
        this.placeBlock(world, pos.func_177974_f(), leaves);
        this.placeBlock(world, pos.func_177976_e(), leaves);
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(world, pos.func_177982_a(x, 1, z), leaves);
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int y = -2; y >= -3; --y) {
                for (int z = -2; z <= 2; ++z) {
                    if ((x == 2 || x == -2) && (z == 2 || z == -2)) continue;
                    this.placeBlock(world, pos.func_177982_a(x, -y, z), leaves);
                }
            }
        }
        pos = pos.func_177981_b(3);
        this.placeBlock(world, pos.func_177964_d(3), leaves);
        this.placeBlock(world, pos.func_177970_e(3), leaves);
        this.placeBlock(world, pos.func_177965_g(3), leaves);
        this.placeBlock(world, pos.func_177985_f(3), leaves);
        if (rand.nextBoolean()) {
            this.placeBlock(world, pos.func_177964_d(4), leaves);
            this.placeBlock(world, pos.func_177970_e(4), leaves);
            this.placeBlock(world, pos.func_177965_g(4), leaves);
            this.placeBlock(world, pos.func_177985_f(4), leaves);
        }
        this.placeBlock(world, pos.func_177978_c(), leaves);
        this.placeBlock(world, pos.func_177968_d(), leaves);
        this.placeBlock(world, pos.func_177974_f(), leaves);
        this.placeBlock(world, pos.func_177976_e(), leaves);
    }
}

