/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class LunossoTreeGenerator
extends TreeGenerator {
    public LunossoTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        switch (rand.nextInt(3)) {
            case 0: {
                return this.generateTree1(world, rand, pos);
            }
            case 1: {
                return this.generateTree2(world, rand, pos);
            }
        }
        return this.generateTree3(world, rand, pos);
    }

    private boolean generateTree1(IWorld world, Random rand, BlockPos pos) {
        int y;
        int leafLoopWidth;
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (leafLoopWidth = 1 + rand.nextInt(2)) + 3, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        movablePos.func_189534_c(Direction.UP, 2);
        int leafLoop = rand.nextInt(3);
        if (leafLoop == 2 || leafLoop == 0) {
            for (int x = -leafLoopWidth; x <= leafLoopWidth; ++x) {
                this.placeBlock(world, movablePos.func_177982_a(x, 0, 0), leaves);
                this.placeBlock(world, movablePos.func_177982_a(x, leafLoopWidth * 2, 0), leaves);
                if (Math.abs(x) != leafLoopWidth) continue;
                for (y = 1; y <= leafLoopWidth + 1; ++y) {
                    this.placeBlock(world, movablePos.func_177982_a(x, y, 0), leaves);
                }
            }
        }
        if (leafLoop == 2 || leafLoop == 1) {
            for (int z = -leafLoopWidth; z <= leafLoopWidth; ++z) {
                this.placeBlock(world, movablePos.func_177982_a(0, 0, z), leaves);
                this.placeBlock(world, movablePos.func_177982_a(0, leafLoopWidth * 2, z), leaves);
                if (Math.abs(z) != leafLoopWidth) continue;
                for (y = 1; y <= leafLoopWidth + 1; ++y) {
                    this.placeBlock(world, movablePos.func_177982_a(0, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree2(IWorld world, Random rand, BlockPos pos) {
        int leafRings;
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (leafRings = 1 + rand.nextInt(3)) * 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        for (int y = 2; y <= leafRings * 2; y += 2) {
            int ringWidth = 1 + rand.nextInt(2);
            for (int x = -ringWidth; x <= ringWidth; ++x) {
                for (int z = -ringWidth; z <= ringWidth; ++z) {
                    if (Math.abs(x) != ringWidth && Math.abs(z) != ringWidth) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree3(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 8, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        movablePos.func_189534_c(Direction.UP, 5);
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (x * x + y * y + z * z != 9) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        return true;
    }
}

