/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class RunicTreeGenerator
extends TreeGenerator {
    public RunicTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(world, rand, pos, 2);
        switch (rand.nextInt(multiSaplingPos != null ? 5 : 4)) {
            case 0: {
                return this.generateTree1(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
            }
            case 1: {
                return this.generateTree2(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
            }
            case 2: {
                return this.generateTree3(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
            }
            case 3: {
                return this.generateTree4(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
            }
            case 4: {
                return this.generateTree5(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
            }
        }
        return false;
    }

    private boolean generateTree1(IWorld world, Random rand, BlockPos pos) {
        int i;
        int leafHeight;
        int trunkHeight = 4 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (leafHeight = 2 + rand.nextInt(3)) - 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        this.placeBlock(world, movablePos.func_177982_a(1, 0, 0), log);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 1), log);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -1), log);
        this.placeBlock(world, movablePos.func_177982_a(-1, 0, 0), log);
        this.placeBlock(world, movablePos.func_177982_a(1, 1, 0), log);
        this.placeBlock(world, movablePos.func_177982_a(0, 1, 1), log);
        this.placeBlock(world, movablePos.func_177982_a(0, 1, -1), log);
        this.placeBlock(world, movablePos.func_177982_a(-1, 1, 0), log);
        for (i = 0; i < leafHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), leaves);
        }
        return true;
    }

    private boolean generateTree2(IWorld world, Random rand, BlockPos pos) {
        int i;
        int trunkHeight = 4 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 3, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        for (i = -2; i < 3; ++i) {
            if (i == 0) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), log);
            if (Math.abs(i) != 2) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 1, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 1, i), log);
        }
        int leafHeight = 2 + rand.nextInt(3);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= leafHeight; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree3(IWorld world, Random rand, BlockPos pos) {
        int i;
        int bulbWidth;
        int trunkHeight = 7 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (bulbWidth = 3 + rand.nextInt(2)) * 2 - 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        for (i = -bulbWidth; i <= bulbWidth; ++i) {
            if (i == 0) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), log);
            if (Math.abs(i) != bulbWidth) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 1, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(i, 2, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 1, i), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 2, i), log);
        }
        for (int x = -bulbWidth + 1; x <= bulbWidth - 1; ++x) {
            for (int z = -bulbWidth + 1; z <= bulbWidth - 1; ++z) {
                for (int y = 1; y <= bulbWidth * 2 - 2; ++y) {
                    if ((y == 1 || y == bulbWidth * 2 - 2) && (Math.abs(x) == bulbWidth - 1 || Math.abs(z) == bulbWidth - 1)) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree4(IWorld world, Random rand, BlockPos pos) {
        int trunkHeight = 9 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        int branchHeight = 2 + rand.nextInt(3);
        for (int i = -4; i <= 4; ++i) {
            if (i == 0) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), log);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), log);
            if (Math.abs(i) != 4) continue;
            for (int j = 1; j <= branchHeight; ++j) {
                this.placeBlock(world, movablePos.func_177982_a(i, -j, 0), log);
                this.placeBlock(world, movablePos.func_177982_a(0, -j, i), log);
            }
        }
        for (int y = -1; y <= 1; ++y) {
            int width = 3 - Math.abs(y);
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    if (x * x + z * z > width * width) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y - 2, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree5(IWorld world, Random rand, BlockPos pos) {
        int z;
        int y;
        int x;
        int leafHeight;
        int trunkHeight = 4 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (leafHeight = 2 + rand.nextInt(5)) - 1, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).func_176223_P();
        for (x = 0; x <= 1; ++x) {
            for (y = 0; y <= trunkHeight; ++y) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, y, z), log);
                }
            }
        }
        for (x = -1; x <= 2; ++x) {
            for (y = 0; y <= 1; ++y) {
                for (z = -1; z <= 2; ++z) {
                    if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                    this.placeBlock(world, pos.func_177982_a(x, trunkHeight + y, z), log);
                }
            }
        }
        for (x = 0; x <= 1; ++x) {
            for (y = 1; y <= leafHeight; ++y) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, trunkHeight + y, z), leaves);
                }
            }
        }
        return true;
    }
}

