/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class ShadowTreeGenerator
extends TreeGenerator {
    public ShadowTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int i;
        int trunkHeight = 8 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.SHADOW_LOG.get()).func_176223_P();
        BlockState barkLog = ((Block)AoABlocks.SHADOW_WOOD.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.SHADOW_LEAVES.get()).func_176223_P();
        int branchWidth = 1 + rand.nextInt(4);
        boolean additionalLeaves = rand.nextBoolean();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), barkLog);
        for (i = 1; i <= branchWidth; ++i) {
            this.placeBlock(world, movablePos.func_177964_d(i), barkLog);
            this.placeBlock(world, movablePos.func_177970_e(i), barkLog);
            this.placeBlock(world, movablePos.func_177965_g(i), barkLog);
            this.placeBlock(world, movablePos.func_177985_f(i), barkLog);
        }
        for (i = branchWidth + 1; i <= branchWidth + 3; ++i) {
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -2, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, 0, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -2, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, -i), leaves);
            if (i == branchWidth + 3) {
                this.placeBlock(world, movablePos.func_177982_a(i, -1, 0), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -1, 0), leaves);
                this.placeBlock(world, movablePos.func_177982_a(0, -1, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(0, -1, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, -i), leaves);
                continue;
            }
            this.placeBlock(world, movablePos.func_177982_a(i, -1, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, -1, i), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, -1, -i), barkLog);
            if (i == branchWidth + 1) {
                this.placeBlock(world, movablePos.func_177982_a(i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, -i), leaves);
            }
            if (!additionalLeaves) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, -1, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -1, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -1, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -1, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -1, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -1, -i), leaves);
        }
        return true;
    }
}

