/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class ShyreTreeGenerator
extends TreeGenerator {
    private final BlockState leavesBlock;

    public ShyreTreeGenerator(@Nullable SaplingBlock sapling, @Nullable LeavesBlock leaves, Random rand) {
        super(sapling);
        this.leavesBlock = leaves == null ? (rand.nextBoolean() ? ((Block)AoABlocks.BRIGHT_SHYRE_LEAVES.get()).func_176223_P() : ((Block)AoABlocks.SHYRE_LEAVES.get()).func_176223_P()) : leaves.func_176223_P();
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        int i;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 3, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.Mutable movablePos = new BlockPos.Mutable(pos.func_177977_b());
        BlockState log = ((Block)AoABlocks.SHYRE_LOG.get()).func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(Direction.UP), log);
        }
        switch (rand.nextInt(4)) {
            case 0: {
                for (i = 0; i >= -2 - rand.nextInt(2); --i) {
                    this.placeBlock(world, movablePos.func_177982_a(-1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, 1), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, -1), this.leavesBlock);
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
                break;
            }
            case 1: {
                for (int y = 0; y >= -1 - rand.nextInt(2); --y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(world, movablePos.func_177982_a(x, y, z), this.leavesBlock);
                        }
                    }
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(-1, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(0, 1, -1), this.leavesBlock);
                break;
            }
            case 2: {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y <= 3; y += 2) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(world, movablePos.func_177982_a(x, y, z), this.leavesBlock);
                        }
                    }
                }
                this.placeBlock(world, movablePos.func_177982_a(-1, 2, -1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 2, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(-1, 2, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 2, -1), this.leavesBlock);
                break;
            }
            case 3: {
                for (i = 0; i <= 3; ++i) {
                    if (i == 1) continue;
                    this.placeBlock(world, movablePos.func_177982_a(-1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, 1), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, -1), this.leavesBlock);
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
            }
        }
        return true;
    }
}

