/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public class StranglewoodTreeGenerator
extends TreeGenerator {
    public StranglewoodTreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos) {
        if ((pos = this.findMultiSaplingPosition(world, rand, pos, 2)) == null) {
            return false;
        }
        int trunkHeight = 10 + rand.nextInt(26);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, i, z), log);
                }
            }
        }
        if (trunkHeight > 15) {
            this.buildTallCrown(world, pos.func_177981_b(trunkHeight - 1), rand);
        } else {
            this.buildShortCrown(world, pos.func_177981_b(trunkHeight - 1), rand);
            for (int x = -1; x <= 2; ++x) {
                for (int z = -1; z <= 2; ++z) {
                    if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                    this.placeBlock(world, pos.func_177982_a(x, trunkHeight - 3, z), leaves);
                }
            }
        }
        return true;
    }

    private void buildTallCrown(IWorld world, BlockPos trunkTopPos, Random rand) {
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).func_176223_P();
        for (int x = 0; x < 5; ++x) {
            this.placeBlock(world, trunkTopPos.func_177982_a(2 + x, 0, 0), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(2 + x, 0, 1), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(-x - 1, 0, 0), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(-x - 1, 0, 1), log);
        }
        for (int z = 0; z < 5; ++z) {
            this.placeBlock(world, trunkTopPos.func_177982_a(0, 0, 2 + z), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(1, 0, 2 + z), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(0, 0, -z - 1), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(1, 0, -z - 1), log);
        }
        this.buildTallNorthSouthLeaves(world, trunkTopPos.func_177982_a(0, 0, 6), rand);
        this.buildTallNorthSouthLeaves(world, trunkTopPos.func_177982_a(0, 0, -5), rand);
        this.buildTallEastWestLeaves(world, trunkTopPos.func_177982_a(-5, 0, 0), rand);
        this.buildTallEastWestLeaves(world, trunkTopPos.func_177982_a(6, 0, 0), rand);
    }

    private void buildTallNorthSouthLeaves(IWorld world, BlockPos centralPos, Random rand) {
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).func_176223_P();
        for (int x = -1; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    this.placeBlock(world, centralPos.func_177982_a(x, y, z), leaves);
                    if (y == 1 && z != -2 && z != 2) {
                        this.placeBlock(world, centralPos.func_177982_a(x, 2, z), leaves);
                        this.placeBlock(world, centralPos.func_177982_a(x, -2, z), leaves);
                    }
                    if (x != 0 || z == -2 || z == 2) continue;
                    this.placeBlock(world, centralPos.func_177982_a(-2, y, z), leaves);
                    this.placeBlock(world, centralPos.func_177982_a(3, y, z), leaves);
                }
            }
        }
    }

    private void buildTallEastWestLeaves(IWorld world, BlockPos centralPos, Random rand) {
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).func_176223_P();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 2; ++z) {
                    this.placeBlock(world, centralPos.func_177982_a(x, y, z), leaves);
                    if (y == 1 && x != -2 && x != 2) {
                        this.placeBlock(world, centralPos.func_177982_a(x, 2, z), leaves);
                        this.placeBlock(world, centralPos.func_177982_a(x, -2, z), leaves);
                    }
                    if (z != 0 || x == -2 || x == 2) continue;
                    this.placeBlock(world, centralPos.func_177982_a(x, y, -2), leaves);
                    this.placeBlock(world, centralPos.func_177982_a(x, y, 3), leaves);
                }
            }
        }
    }

    private void buildShortCrown(IWorld world, BlockPos trunkTopPos, Random rand) {
        int i;
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).func_176223_P();
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).func_176223_P();
        for (i = 0; i < 4; ++i) {
            this.placeBlock(world, trunkTopPos.func_177982_a(i + 2, -4 + i, 0), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(i + 2, -4 + i, 1), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(0, -4 + i, i + 2), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(1, -4 + i, i + 2), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(-1 + -i, -4 + i, 0), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(-1 + -i, -4 + i, 1), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(0, -4 + i, -1 + -i), log);
            this.placeBlock(world, trunkTopPos.func_177982_a(1, -4 + i, -1 + -i), log);
        }
        for (i = 5; i > 2; --i) {
            for (int x2 = -i; x2 <= i + 1; ++x2) {
                for (int z2 = -i; z2 <= i + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > i - (Math.abs(z3) - 2)) continue;
                    this.placeBlock(world, trunkTopPos.func_177982_a(x2, 7 - i - 3, z2), leaves);
                }
            }
        }
    }
}

