/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.block.decoration.sapling.SaplingBlock;
import net.tslat.aoa3.worldgen.WorldGenerator;
import org.apache.commons.lang3.tuple.Triple;

public abstract class TreeGenerator
extends WorldGenerator {
    protected final SaplingBlock sapling;

    public TreeGenerator(@Nullable SaplingBlock sapling) {
        super(sapling != null);
        this.sapling = sapling;
    }

    @Override
    public abstract boolean generate(IWorld var1, Random var2, BlockPos var3);

    protected void placeBlock(IWorld world, BlockPos pos, BlockState state, boolean overwriteBlocks) {
        if (!overwriteBlocks && !TreeGenerator.isSafeBlock(world, pos)) {
            return;
        }
        this.setBlockAndNotifyAdequately(world, pos, state);
    }

    protected void placeBlock(IWorld world, BlockPos pos, BlockState state) {
        this.placeBlock(world, pos, state, false);
    }

    protected static boolean isSafeBlock(IWorld world, BlockPos pos) {
        BlockState existingState = world.func_180495_p(pos);
        Block existingBlock = existingState.func_177230_c();
        return existingBlock.isAir(existingState, (IBlockReader)world, pos) || existingState.func_185904_a().func_76222_j() || existingBlock.func_203417_a(BlockTags.field_206952_E);
    }

    protected boolean checkSafeHeight(IWorld world, BlockPos pos, int maxHeight, int trunkWidth) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + maxHeight < 256) {
            if (this.sapling == null) {
                return true;
            }
            for (int i = 1; i <= maxHeight; ++i) {
                for (int x = 0; x < trunkWidth; ++x) {
                    for (int z = 0; z < trunkWidth; ++z) {
                        if (TreeGenerator.isSafeBlock(world, pos.func_177982_a(x, i, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean checkAndPrepSoil(IWorld world, BlockPos pos, int trunkWidth) {
        if (this.sapling == null) {
            return true;
        }
        ArrayList<Triple> soils = new ArrayList<Triple>(trunkWidth * trunkWidth);
        for (int x = 0; x < trunkWidth; ++x) {
            for (int z = 0; z < trunkWidth; ++z) {
                BlockPos soilPos = pos.func_177982_a(x, -1, z);
                BlockState soilState = world.func_180495_p(soilPos);
                Block soil = soilState.func_177230_c();
                if (soil.isAir(soilState, (IBlockReader)world, soilPos.func_177984_a()) || !soil.canSustainPlant(soilState, (IBlockReader)world, soilPos, Direction.UP, (IPlantable)this.sapling)) {
                    return false;
                }
                soils.add(Triple.of((Object)soilState, (Object)soil, (Object)soilPos));
            }
        }
        for (Triple soil : soils) {
            ((Block)soil.getMiddle()).onPlantGrow((BlockState)soil.getLeft(), world, (BlockPos)soil.getRight(), ((BlockPos)soil.getRight()).func_177984_a());
            world.func_180501_a(((BlockPos)soil.getRight()).func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        return true;
    }

    @Nullable
    protected BlockPos findMultiSaplingPosition(IWorld world, Random rand, BlockPos pos, int size) {
        if (this.sapling == null) {
            return pos;
        }
        for (int x = 0; x >= -(size - 1); --x) {
            block1: for (int z = 0; z >= -(size - 1); --z) {
                BlockPos checkPos = pos;
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        checkPos = pos.func_177982_a(x + i, 0, z + j);
                        if (world.func_180495_p(checkPos).func_177230_c() != this.sapling) continue block1;
                    }
                }
                return checkPos.func_177982_a(-size + 1, 0, -size + 1);
            }
        }
        return null;
    }
}

